/*
 * Decompiled with CFR 0.152.
 */
package com.truv.webview;

import android.util.Log;
import android.webkit.JavascriptInterface;
import com.truv.models.ExternalLoginConfig;
import com.truv.models.TruvEventPayload;
import com.truv.models.TruvSuccessPayload;
import com.truv.webview.TruvEventsListener;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/truv/webview/WebAppInterface;", "", "eventListeners", "", "Lcom/truv/webview/TruvEventsListener;", "onShowExternalWebView", "Lkotlin/Function1;", "Lcom/truv/models/ExternalLoginConfig;", "", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "onClose", "onError", "onEvent", "event", "", "onLoad", "onSuccess", "payload", "Companion", "truv_bridge_release"})
@SourceDebugExtension(value={"SMAP\nWebAppInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebAppInterface.kt\ncom/truv/webview/WebAppInterface\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n1855#2,2:70\n1855#2,2:72\n1855#2,2:74\n1855#2,2:76\n1855#2,2:78\n*S KotlinDebug\n*F\n+ 1 WebAppInterface.kt\ncom/truv/webview/WebAppInterface\n*L\n21#1:68,2\n24#1:70,2\n38#1:72,2\n48#1:74,2\n54#1:76,2\n60#1:78,2\n*E\n"})
public final class WebAppInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<TruvEventsListener> eventListeners;
    @Nullable
    private final Function1<ExternalLoginConfig, Unit> onShowExternalWebView;
    @NotNull
    public static final String TAG = "TruvBridgeView";

    public WebAppInterface(@NotNull Set<? extends TruvEventsListener> eventListeners, @Nullable Function1<? super ExternalLoginConfig, Unit> onShowExternalWebView) {
        Intrinsics.checkNotNullParameter(eventListeners, (String)"eventListeners");
        this.eventListeners = eventListeners;
        this.onShowExternalWebView = onShowExternalWebView;
    }

    public /* synthetic */ WebAppInterface(Set set, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(set, (Function1<? super ExternalLoginConfig, Unit>)function1);
    }

    @JavascriptInterface
    public final void onSuccess(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Log.d((String)TAG, (String)("onSuccess invoked " + payload));
        try {
            TruvSuccessPayload successPayload = TruvSuccessPayload.Companion.fromJson(payload);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TruvEventsListener it = (TruvEventsListener)element$iv;
                boolean bl = false;
                it.onSuccess(successPayload);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Json exception at onSuccess invoked " + payload), (Throwable)e);
            Iterable $this$forEach$iv = this.eventListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TruvEventsListener it = (TruvEventsListener)element$iv;
                boolean bl = false;
                it.onError();
            }
        }
    }

    @JavascriptInterface
    public final void onEvent(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Log.d((String)TAG, (String)("onEvent invoked " + event));
        try {
            TruvEventPayload eventPayload = TruvEventPayload.Companion.fromJson(event);
            if (eventPayload.getEventType() == TruvEventPayload.EventType.START_EXTERNAL_LOGIN && eventPayload.getPayload() != null && this.onShowExternalWebView != null) {
                this.onShowExternalWebView.invoke((Object)eventPayload.getPayload().getExternalLoginConfig());
            } else {
                Iterable $this$forEach$iv = this.eventListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TruvEventsListener it = (TruvEventsListener)element$iv;
                    boolean bl = false;
                    it.onEvent(eventPayload);
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Json exception at onEvent invoked " + event), (Throwable)e);
        }
    }

    @JavascriptInterface
    public final void onClose() {
        Log.d((String)TAG, (String)"onClose invoked");
        Iterable $this$forEach$iv = this.eventListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TruvEventsListener it = (TruvEventsListener)element$iv;
            boolean bl = false;
            it.onClose();
        }
    }

    @JavascriptInterface
    public final void onLoad() {
        Log.d((String)TAG, (String)"onLoad invoked");
        Iterable $this$forEach$iv = this.eventListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TruvEventsListener it = (TruvEventsListener)element$iv;
            boolean bl = false;
            it.onLoad();
        }
    }

    @JavascriptInterface
    public final void onError() {
        Log.d((String)TAG, (String)"onError invoked");
        Iterable $this$forEach$iv = this.eventListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TruvEventsListener it = (TruvEventsListener)element$iv;
            boolean bl = false;
            it.onError();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/truv/webview/WebAppInterface$Companion;", "", "()V", "TAG", "", "truv_bridge_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

