/*
 * Decompiled with CFR 0.152.
 */
package com.truv.webview;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.truv.webview.ExternalWebViewBottomSheetKt;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001-Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ$\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0018J'\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0006J\u001c\u0010 \u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010!\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J \u0010%\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020'H\u0016J\u001c\u0010,\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lcom/truv/webview/ExternalWebViewClient;", "Landroid/webkit/WebViewClient;", "context", "Landroid/content/Context;", "onLoading", "Lkotlin/Function1;", "", "", "onLoaded", "Lkotlin/Function0;", "onLoadingError", "openExternalLinkInAppBrowser", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "allRequests", "", "isLoading", "seenURLs", "doUpdateVisitedHistory", "view", "Landroid/webkit/WebView;", "url", "isReload", "getAllRequestURLs", "", "getSeenPages", "getStorageValues", "", "Lcom/truv/webview/ExternalWebViewClient$StorageItem;", "type", "(Ljava/lang/String;Landroid/webkit/WebView;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isWebViewLoading", "onPageCommitVisible", "onPageFinished", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "shouldOverrideUrlLoading", "StorageItem", "truv_bridge_release"})
public final class ExternalWebViewClient
extends WebViewClient {
    @NotNull
    private final Context context;
    @NotNull
    private final Function1<Boolean, Unit> onLoading;
    @NotNull
    private final Function0<Unit> onLoaded;
    @NotNull
    private final Function1<Boolean, Unit> onLoadingError;
    @Nullable
    private final Function1<String, Unit> openExternalLinkInAppBrowser;
    @NotNull
    private final Set<String> seenURLs;
    @NotNull
    private final Set<String> allRequests;
    private boolean isLoading;

    public ExternalWebViewClient(@NotNull Context context, @NotNull Function1<? super Boolean, Unit> onLoading, @NotNull Function0<Unit> onLoaded, @NotNull Function1<? super Boolean, Unit> onLoadingError, @Nullable Function1<? super String, Unit> openExternalLinkInAppBrowser) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onLoading, (String)"onLoading");
        Intrinsics.checkNotNullParameter(onLoaded, (String)"onLoaded");
        Intrinsics.checkNotNullParameter(onLoadingError, (String)"onLoadingError");
        this.context = context;
        this.onLoading = onLoading;
        this.onLoaded = onLoaded;
        this.onLoadingError = onLoadingError;
        this.openExternalLinkInAppBrowser = openExternalLinkInAppBrowser;
        this.seenURLs = new LinkedHashSet();
        this.allRequests = new LinkedHashSet();
    }

    public /* synthetic */ ExternalWebViewClient(Context context, Function1 function1, Function0 function0, Function1 function12, Function1 function13, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function0 = 2.INSTANCE;
        }
        if ((n & 8) != 0) {
            function12 = 3.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function13 = null;
        }
        this(context, (Function1<? super Boolean, Unit>)function1, (Function0<Unit>)function0, (Function1<? super Boolean, Unit>)function12, (Function1<? super String, Unit>)function13);
    }

    public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.isLoading = true;
        this.seenURLs.add(url);
        this.allRequests.add(url);
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(@Nullable WebView view, @Nullable String url) {
        this.isLoading = false;
        super.onPageFinished(view, url);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getRequestHeaders().containsKey("X-Requested-With")) {
            request.getRequestHeaders().remove("X-Requested-With");
        }
        String string2 = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.allRequests.add(string2);
        return super.shouldInterceptRequest(view, request);
    }

    public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
        WebResourceRequest webResourceRequest = request;
        Log.d((String)"ExternalWebViewClient", (String)("URL: " + (webResourceRequest != null ? webResourceRequest.getUrl() : null)));
        this.onLoading.invoke((Object)true);
        WebResourceRequest webResourceRequest2 = request;
        if (webResourceRequest2 != null) {
            WebResourceRequest it = webResourceRequest2;
            boolean bl = false;
            Function1<String, Unit> function1 = this.openExternalLinkInAppBrowser;
            if (function1 != null) {
                String string2 = it.getUrl().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                function1.invoke((Object)string2);
            } else {
                ExternalWebViewClient $this$shouldOverrideUrlLoading_u24lambda_u241_u24lambda_u240 = this;
                boolean bl2 = false;
                WebView webView2 = view;
                if (webView2 != null) {
                    webView2.loadUrl(it.getUrl().toString());
                }
            }
        }
        WebResourceRequest webResourceRequest3 = request;
        this.seenURLs.add(String.valueOf(webResourceRequest3 != null ? webResourceRequest3.getUrl() : null));
        WebResourceRequest webResourceRequest4 = request;
        this.allRequests.add(String.valueOf(webResourceRequest4 != null ? webResourceRequest4.getUrl() : null));
        return true;
    }

    public void onPageCommitVisible(@Nullable WebView view, @Nullable String url) {
        super.onPageCommitVisible(view, url);
        this.onLoading.invoke((Object)false);
        this.onLoaded.invoke();
    }

    public void doUpdateVisitedHistory(@Nullable WebView view, @Nullable String url, boolean isReload) {
        Log.d((String)"ExternalWebViewClient", (String)("doUpdateVisitedHistory: " + url));
        if (url != null) {
            this.seenURLs.add(url);
            this.allRequests.add(url);
        }
        super.doUpdateVisitedHistory(view, url, isReload);
    }

    public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceError error) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super.onReceivedError(view, request, error);
        if (Build.VERSION.SDK_INT >= 23) {
            if (error.getErrorCode() == -6 || error.getErrorCode() == -8 || error.getErrorCode() == -2) {
                this.onLoadingError.invoke((Object)true);
            } else {
                this.onLoadingError.invoke((Object)false);
            }
        }
    }

    @Nullable
    public final Object getStorageValues(@NotNull String type, @NotNull WebView view, @NotNull Continuation<? super List<StorageItem>> $completion) {
        Continuation<? super List<StorageItem>> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        view.evaluateJavascript("\n            (function() {\n              const items = [];\n              for (let i = 0; i < " + type + ".length; i++) {\n                const key = " + type + ".key(i);\n                items.push({\n                  key: key,\n                  value: " + type + ".getItem(key),\n                  domain: window.location.hostname\n                });\n              }\n              return items;\n            })();\n            ", new ValueCallback(type, (Continuation<? super List<StorageItem>>)continuation2){
            final /* synthetic */ String $type;
            final /* synthetic */ Continuation<List<StorageItem>> $continuation;
            {
                this.$type = $type;
                this.$continuation = $continuation;
            }

            public final void onReceiveValue(String value) {
                Object object;
                Log.d((String)ExternalWebViewBottomSheetKt.getTAG(), (String)("Storage: " + this.$type + ", " + value));
                Object object2 = this.$type;
                try {
                    List list;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)value, (Object)"null")) {
                        list = CollectionsKt.emptyList();
                    } else {
                        List list2;
                        try {
                            JSONArray jsonArray = new JSONArray(value);
                            Log.d((String)ExternalWebViewBottomSheetKt.getTAG(), (String)("jsonArray for " + (String)object2 + ": " + jsonArray));
                            List items = new ArrayList<E>();
                            int n = jsonArray.length();
                            for (int i = 0; i < n; ++i) {
                                JSONObject item = jsonArray.getJSONObject(i);
                                String string2 = item.getString("key");
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                                String string3 = item.getString("value");
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                                String string4 = item.getString("domain");
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                                items.add(new StorageItem(string2, string3, string4));
                            }
                            list2 = items;
                        }
                        catch (Exception e) {
                            Log.d((String)ExternalWebViewBottomSheetKt.getTAG(), (String)("error: " + e));
                            throw e;
                        }
                        list = list2;
                    }
                    object = Result.constructor-impl((Object)list);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                object = CollectionsKt.emptyList();
                List values = (List)(Result.isFailure-impl((Object)object2) ? object : object2);
                this.$continuation.resumeWith(Result.constructor-impl((Object)values));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @NotNull
    public final Set<String> getSeenPages() {
        return CollectionsKt.toSet((Iterable)this.seenURLs);
    }

    @NotNull
    public final Set<String> getAllRequestURLs() {
        return CollectionsKt.toSet((Iterable)this.allRequests);
    }

    public final boolean isWebViewLoading() {
        return this.isLoading;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/truv/webview/ExternalWebViewClient$StorageItem;", "", "key", "", "value", "domain", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDomain", "()Ljava/lang/String;", "getKey", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "truv_bridge_release"})
    public static final class StorageItem {
        @NotNull
        private final String key;
        @NotNull
        private final String value;
        @NotNull
        private final String domain;

        public StorageItem(@NotNull String key, @NotNull String value, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            this.key = key;
            this.value = value;
            this.domain = domain;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getDomain() {
            return this.domain;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final String component3() {
            return this.domain;
        }

        @NotNull
        public final StorageItem copy(@NotNull String key, @NotNull String value, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            return new StorageItem(key, value, domain);
        }

        public static /* synthetic */ StorageItem copy$default(StorageItem storageItem, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = storageItem.key;
            }
            if ((n & 2) != 0) {
                string3 = storageItem.value;
            }
            if ((n & 4) != 0) {
                string4 = storageItem.domain;
            }
            return storageItem.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "StorageItem(key=" + this.key + ", value=" + this.value + ", domain=" + this.domain + ')';
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.domain.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StorageItem)) {
                return false;
            }
            StorageItem storageItem = (StorageItem)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)storageItem.key)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)storageItem.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.domain, (Object)storageItem.domain);
        }
    }
}

