/*
 * Decompiled with CFR 0.152.
 */
package com.truward.di.support;

import com.truward.di.InjectionContext;
import com.truward.di.InjectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public class DefaultInjectionContext
implements InjectionContext {
    private List<BeanHolder<?>> beanHolders = new ArrayList();
    private Map<Class<?>, BeanHolder<?>> cachedInterfaceMap = new HashMap();
    private static final BeanHolder<Object> NIL_BEAN_HOLDER = new BeanHolder<Boolean>(Boolean.FALSE);
    private boolean frozen;

    @Override
    public <T> void registerBean(@Nonnull T bean) {
        this.shouldNotBeFrozen();
        this.addUninitializedBean(bean);
    }

    @Override
    public <T> void registerBean(@Nonnull Class<T> beanClass) {
        this.shouldNotBeFrozen();
        try {
            this.addUninitializedBean(this.constructBean(beanClass));
        }
        catch (InstantiationException e) {
            throw new InjectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new InjectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new InjectionException(e);
        }
    }

    @Override
    @Nonnull
    public <T> T getBean(@Nonnull Class<T> beanClass) {
        if (beanClass.equals(InjectionContext.class)) {
            return beanClass.cast(this);
        }
        return this.getInitializedBean(this.findBeanHolder(beanClass), beanClass);
    }

    @Override
    @Nonnull
    public <T> List<T> getBeans(@Nonnull Class<T> beanClass) {
        BeanHolder<?> beanHolder = this.cachedInterfaceMap.get(beanClass);
        if (beanHolder == null) {
            return Collections.emptyList();
        }
        if (beanHolder != NIL_BEAN_HOLDER) {
            return Collections.singletonList(this.getInitializedBean(beanHolder, beanClass));
        }
        ArrayList<T> beans = new ArrayList<T>();
        for (BeanHolder<?> holder : this.beanHolders) {
            if (!beanClass.isAssignableFrom(holder.bean.getClass())) continue;
            beans.add(this.getInitializedBean(holder, beanClass));
        }
        return Collections.unmodifiableList(beans);
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    private void shouldNotBeFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Modifications are not allowed for frozen injection context");
        }
    }

    private static void addInterfacesToSink(@Nonnull Set<Class<?>> interfaceSink, @Nonnull Class<?> targetClass) {
        Class<?> superclass;
        if (!targetClass.isInterface() && (superclass = targetClass.getSuperclass()) != null) {
            DefaultInjectionContext.addInterfacesToSink(interfaceSink, superclass);
        }
        for (Class<?> interfaceClass : targetClass.getInterfaces()) {
            interfaceSink.add(interfaceClass);
            DefaultInjectionContext.addInterfacesToSink(interfaceSink, interfaceClass);
        }
    }

    private void cacheInterfaces(@Nonnull BeanHolder<?> beanHolder) {
        HashSet interfaceSink = new HashSet();
        DefaultInjectionContext.addInterfacesToSink(interfaceSink, beanHolder.bean.getClass());
        for (Class clazz : interfaceSink) {
            BeanHolder<?> assoc = this.cachedInterfaceMap.get(clazz);
            if (assoc != null) {
                if (assoc == NIL_BEAN_HOLDER) continue;
                this.cachedInterfaceMap.put(clazz, NIL_BEAN_HOLDER);
                continue;
            }
            this.cachedInterfaceMap.put(clazz, beanHolder);
        }
    }

    @Nonnull
    private BeanHolder<?> findBeanHolder(@Nonnull Class<?> beanClass) {
        BeanHolder<?> beanHolder = this.cachedInterfaceMap.get(beanClass);
        if (beanHolder != null && beanHolder != NIL_BEAN_HOLDER) {
            return beanHolder;
        }
        beanHolder = null;
        for (BeanHolder<?> holder : this.beanHolders) {
            if (!beanClass.isAssignableFrom(holder.bean.getClass())) continue;
            if (beanHolder != null) {
                throw new InjectionException("Ambigous definition for class " + beanClass + " conflicting definitions are: " + holder.bean + " and " + beanHolder.bean);
            }
            beanHolder = holder;
        }
        if (beanHolder == null) {
            throw new InjectionException("The requested bean of class " + beanClass + " has not been found");
        }
        return beanHolder;
    }

    private <T> void addUninitializedBean(@Nonnull T bean) {
        for (BeanHolder<?> beanHolder : this.beanHolders) {
            if (beanHolder.bean == bean) {
                throw new InjectionException("Duplicate declaration of bean " + bean);
            }
            if (!beanHolder.bean.getClass().equals(bean.getClass())) continue;
            throw new InjectionException("The context already have definition of bean with class " + bean.getClass());
        }
        BeanHolder<T> beanHolder = new BeanHolder<T>(bean);
        this.beanHolders.add(beanHolder);
        this.cacheInterfaces(beanHolder);
    }

    @Nonnull
    private <T> T constructBean(@Nonnull Class<T> beanClass) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (beanClass.isInterface()) {
            throw new InjectionException("The given class is interface: " + beanClass);
        }
        T beanInstance = null;
        for (Constructor<?> ctor : beanClass.getConstructors()) {
            if (beanInstance != null) {
                throw new InjectionException("Bean " + beanClass + " defines multiple constructors");
            }
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.getBean(parameterTypes[i]);
            }
            beanInstance = beanClass.cast(ctor.newInstance(parameters));
        }
        if (beanInstance == null) {
            beanInstance = beanClass.newInstance();
        }
        return beanInstance;
    }

    @Nonnull
    private <T> T getInitializedBean(@Nonnull BeanHolder<?> beanHolder, @Nonnull Class<T> beanClass) {
        if (!beanHolder.initialized) {
            try {
                this.initializeBeanHolder(beanHolder);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Illegal access error when initializing class " + beanClass, e);
            }
            catch (InvocationTargetException e) {
                throw new InjectionException("Invocation error when initializing class " + beanClass, e);
            }
        }
        return beanClass.cast(beanHolder.bean);
    }

    private <T> void initializeBeanHolder(@Nonnull BeanHolder<T> beanHolder) throws IllegalAccessException, InvocationTargetException {
        Class<?> beanImplClass;
        ArrayList classes = new ArrayList();
        for (Class<?> c = beanImplClass = beanHolder.bean.getClass(); c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            classes.add(c);
        }
        for (Class clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                Resource resourceAnnotation = field.getAnnotation(Resource.class);
                if (resourceAnnotation == null) continue;
                if (!resourceAnnotation.mappedName().isEmpty()) {
                    throw new UnsupportedOperationException("Beans with mappedName are not supported, class: " + beanImplClass + ", field: " + field.getName() + ", " + "mappedName: " + resourceAnnotation.mappedName());
                }
                boolean wasAccessible = field.isAccessible();
                if (!wasAccessible) {
                    field.setAccessible(true);
                }
                assert (field.get(beanHolder.bean) == null);
                field.set(beanHolder.bean, this.getBean(field.getType()));
                if (wasAccessible) continue;
                field.setAccessible(false);
            }
        }
        assert (beanImplClass != null);
        for (Method method : beanImplClass.getMethods()) {
            if (method.getAnnotation(PostConstruct.class) == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new UnsupportedOperationException("Method " + method + " is declared as post construct, but " + "it takes parameters which is not supported");
            }
            method.invoke(beanHolder.bean, new Object[0]);
        }
        beanHolder.initialized = true;
    }

    private static final class BeanHolder<T> {
        boolean initialized = false;
        @Nonnull
        final T bean;

        BeanHolder(@Nonnull T bean) {
            this.bean = bean;
        }
    }
}

