/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.WicketWebElement;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class ByWicketIdPathFastVersion
extends By {
    private String path;
    private Pattern stepPattern;

    public ByWicketIdPathFastVersion(String path) {
        this.path = path;
        this.stepPattern = Pattern.compile("(//?)([\\w\\.]+)(\\[(\\d+)\\])?");
    }

    public List<WebElement> findElements(SearchContext context) {
        WebElement element = this.findByPath(context, this.path);
        return element == null ? null : Arrays.asList(element);
    }

    private WicketWebElement getRootElement(SearchContext context, String wicketId) {
        WicketWebElement root;
        List elements = context.findElements(By.xpath((String)("//*[(@wicketpath = '" + wicketId + "') or (starts-with(@wicketpath, '" + wicketId + "_')) or (contains(@wicketpath, '_" + wicketId + "_')) or ('_" + wicketId + "' = substring(@wicketpath, string-length(@wicketpath)- string-length('_" + wicketId + "') +1))]")));
        WicketWebElement last = root = new WicketWebElement();
        for (WebElement element : elements) {
            try {
                WicketWebElement node = new WicketWebElement(element);
                last.findParent(node).add(node);
                last = node;
            }
            catch (StaleElementReferenceException staleElementReferenceException) {}
        }
        return root;
    }

    public WebElement findByPath(SearchContext context, String path) {
        Matcher matcher = this.stepPattern.matcher(path);
        WicketWebElement baseElement = null;
        while (matcher.find()) {
            WicketWebElement child;
            boolean hasNoRootYet;
            boolean isAnyLevelDeep = matcher.group(1).equals("//");
            String wicketId = matcher.group(2);
            String indexString = matcher.group(4);
            int index = 0;
            if (indexString != null) {
                index = Integer.parseInt(indexString);
            }
            boolean bl = hasNoRootYet = baseElement == null;
            if (hasNoRootYet) {
                baseElement = this.getRootElement(context, wicketId);
            }
            if ((child = this.findByWicketId(baseElement, isAnyLevelDeep, wicketId, index)) == null) {
                return null;
            }
            baseElement = child;
        }
        return baseElement == null ? null : baseElement.getElement();
    }

    private WicketWebElement findByWicketId(WicketWebElement baseElement, boolean isAnyLevelDeep, String wicketId, int index) {
        int noElementsFound = 0;
        ArrayDeque<WicketWebElement> queue = new ArrayDeque<WicketWebElement>();
        queue.addAll(baseElement.getChildren());
        while (!queue.isEmpty()) {
            WicketWebElement child = (WicketWebElement)queue.poll();
            if (this.matchesWicketId(child.getElement(), wicketId)) {
                if (noElementsFound == index) {
                    return child;
                }
                ++noElementsFound;
            }
            if (!isAnyLevelDeep) continue;
            queue.addAll(child.getChildren());
        }
        return null;
    }

    public boolean matchesWicketId(WebElement element, String wicketId) {
        try {
            String wicketIdValue = element.getAttribute("wicket:id");
            if (wicketIdValue != null && wicketIdValue.equals(wicketId)) {
                return true;
            }
            String wicketPathPattern = "^((.*[^_])_)*" + wicketId.replace(".", "\\.").replace("_", "__") + "(_\\d+)?$";
            String pathValue = element.getAttribute("wicketpath");
            if (pathValue != null && pathValue.matches(wicketPathPattern)) {
                return true;
            }
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.path;
    }
}

