/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.WebAppJettyConfiguration;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends WebAppJettyConfiguration {
    private static Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static final String FIREFOX_DRIVER_FULL_NAME = "org.openqa.selenium.firefox.FirefoxDriver";
    private static final String PROPERTY_KEY_WEBDRIVER_CLASS = "com.ttdev.wicketpagetest.webdriver.class";
    private String wicketFilterPrefix = "app";
    private WebDriver selenium = null;

    public String getWicketFilterPrefix() {
        return this.wicketFilterPrefix;
    }

    public void setWicketFilterPrefix(String wicketFilterPrefix) {
        this.wicketFilterPrefix = wicketFilterPrefix;
    }

    public WebDriver getSelenium() {
        if (this.selenium == null) {
            try {
                String className = System.getProperty(PROPERTY_KEY_WEBDRIVER_CLASS, FIREFOX_DRIVER_FULL_NAME);
                LOGGER.info("Loading class as webdriver: {}", (Object)className);
                Class<?> driverClass = Class.forName(className);
                this.selenium = (WebDriver)driverClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.selenium;
    }

    public void setSelenium(WebDriver selenium) {
        this.selenium = selenium;
    }
}

