/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleLauncher {
    private static Logger LOGGER = LoggerFactory.getLogger(ConsoleLauncher.class);
    private Process p;
    private String cmdExecutingConsole;

    public ConsoleLauncher() {
        String osName = System.getProperty("os.name").toLowerCase();
        this.cmdExecutingConsole = osName.contains("win") ? "cmd /c start" : "x-terminal-emulator -e";
    }

    public void launchConsoleToExecute(String[] cmdToExecute) {
        String fullCmdLine = this.cmdExecutingConsole;
        for (String cmdPart : cmdToExecute) {
            fullCmdLine = fullCmdLine + " " + this.quoteAsNeeded(cmdPart);
        }
        LOGGER.info("Executing {}", (Object)fullCmdLine);
        try {
            this.p = Runtime.getRuntime().exec(fullCmdLine);
            this.ignoreChildIO();
        }
        catch (IOException e) {
            LOGGER.warn("Error launching the command in console", (Throwable)e);
        }
    }

    private void ignoreChildIO() throws IOException {
        this.p.getInputStream().close();
        this.p.getErrorStream().close();
        this.p.getOutputStream().close();
    }

    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    private String quoteAsNeeded(String c) {
        return c.contains(" ") ? "\"" + c + "\"" : c;
    }
}

