/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ObjectFactory {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();

    public <T> T create(Class<T> objClass, Object ... constructorArgs) {
        for (Constructor<?> c : objClass.getConstructors()) {
            Constructor<?> ctor = c;
            Class<?>[] types = ctor.getParameterTypes();
            if (!this.typesMatchingArgs(types, constructorArgs)) continue;
            try {
                return (T)ctor.newInstance(constructorArgs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Not matching constructor found in class: " + objClass.getName());
    }

    private boolean typesMatchingArgs(Class<?>[] types, Object[] constructorArgs) {
        if (types.length != constructorArgs.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (this.isAssignableFrom(types[i], constructorArgs[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignableFrom(Class<?> to, Class<?> from) {
        if (PRIMITIVE_TO_WRAPPER.get(from) == to || PRIMITIVE_TO_WRAPPER.get(to) == from) {
            return true;
        }
        return to.isAssignableFrom(from);
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
    }
}

