/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.WebAppJettyConfiguration;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppJettyLauncher {
    private WebAppContext context;
    private Server server;

    public void startAppInJetty(WebAppJettyConfiguration cfg) {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(cfg.getJettyServerPort());
        this.server.addConnector((Connector)connector);
        this.context = new WebAppContext();
        this.context.setContextPath("/");
        this.context.setWar(cfg.getDocBase());
        this.context.setOverrideDescriptor(cfg.getOverrideWebXml());
        this.server.setHandler((Handler)this.context);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stopJetty() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServletContext getServletContext() {
        return this.context.getServletHandler().getServletContext();
    }

    public FilterHolder[] getFilters() {
        return this.context.getServletHandler().getFilters();
    }
}

