/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.Configuration;
import com.ttdev.wicketpagetest.WicketAppJettyLauncher;
import com.ttdev.wicketpagetest.WicketSeleniumDriver;
import org.apache.wicket.protocol.http.WebApplication;
import org.openqa.selenium.WebDriver;

public class WebPageTestBasicContext {
    private static WebPageTestBasicContext instance;
    private WebDriver selenium;
    private WicketSeleniumDriver wicketSelenium;
    private WicketAppJettyLauncher jettyLauncher;
    private Configuration cfg;

    public static void beforePageTests() throws Exception {
        WebPageTestBasicContext.beforePageTests(new Configuration());
    }

    public static void beforePageTests(Configuration cfg) throws Exception {
        instance = new WebPageTestBasicContext();
        instance.start(cfg);
    }

    public static Configuration getConfiguration() {
        return WebPageTestBasicContext.instance.cfg;
    }

    public static WicketSeleniumDriver getWicketSelenium() {
        return WebPageTestBasicContext.instance.wicketSelenium;
    }

    private void start(Configuration cfg) {
        this.cfg = cfg;
        this.startWebAppInJetty();
        this.startSelenium();
    }

    private void startWebAppInJetty() {
        this.jettyLauncher = new WicketAppJettyLauncher();
        this.jettyLauncher.startAppInJetty(this.cfg);
    }

    private void startSelenium() {
        this.selenium = this.cfg.getSelenium();
        this.wicketSelenium = new WicketSeleniumDriver(this.cfg, this.selenium);
    }

    public static void afterPageTests() throws Exception {
        instance.stop();
    }

    private void stop() {
        this.stopSelenium();
        this.stopJetty();
    }

    private void stopJetty() {
        if (this.jettyLauncher != null) {
            this.jettyLauncher.stopJetty();
        }
    }

    private void stopSelenium() {
        if (this.selenium != null) {
            this.selenium.quit();
        }
    }

    public WebApplication getApplication() {
        return this.jettyLauncher.getApplication();
    }

    public static WebDriver getSelenium() {
        return WebPageTestBasicContext.instance.selenium;
    }

    public static WebApplication getWebApplication() {
        return instance.getApplication();
    }
}

