/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.WebAppJettyConfiguration;
import com.ttdev.wicketpagetest.WebAppJettyLauncher;
import java.lang.reflect.Method;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.eclipse.jetty.servlet.FilterHolder;

public class WicketAppJettyLauncher
extends WebAppJettyLauncher {
    @Override
    public void startAppInJetty(WebAppJettyConfiguration cfg) {
        super.startAppInJetty(cfg);
        this.waitForApplication();
        this.enableOutputWicketPath();
    }

    private void enableOutputWicketPath() {
        try {
            Method getDebugSettings = Application.class.getMethod("getDebugSettings", new Class[0]);
            Object debugSettings = getDebugSettings.invoke((Object)this.getApplication(), new Object[0]);
            Method setOutputComponentPath = debugSettings.getClass().getMethod("setOutputComponentPath", Boolean.TYPE);
            setOutputComponentPath.invoke(debugSettings, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForApplication() {
        WebApplication app;
        while (true) {
            if ((app = this.getApplication()) != null) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        ThreadContext.setApplication((Application)app);
    }

    public WebApplication getApplication() {
        return (WebApplication)PropertyResolver.getValue((String)"application", (Object)this.getWicketFilter());
    }

    private WicketFilter getWicketFilter() {
        for (FilterHolder h : this.getFilters()) {
            if (!h.getHeldClass().equals(WicketFilter.class)) continue;
            return (WicketFilter)h.getFilter();
        }
        throw new RuntimeException("WicketFilter not found");
    }
}

