/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.google.common.base.Predicate;
import com.ttdev.wicketpagetest.BreadCrumbPanelTestPage;
import com.ttdev.wicketpagetest.ByWicketIdPathFastVersion;
import com.ttdev.wicketpagetest.ComponentFactory;
import com.ttdev.wicketpagetest.ComponentTestPage;
import com.ttdev.wicketpagetest.Configuration;
import com.ttdev.wicketpagetest.DefaultPageFactory;
import com.ttdev.wicketpagetest.LauncherPage;
import com.ttdev.wicketpagetest.MockableBeanInjector;
import com.ttdev.wicketpagetest.PageMarkingListener;
import com.ttdev.wicketpagetest.SwitchLocalePage;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.extensions.breadcrumb.panel.IBreadCrumbPanelFactory;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketSelenium {
    private static final Logger LOGGER = LoggerFactory.getLogger(WicketSelenium.class);
    protected static final int WAIT_TIMEOUT_IN_SECONDS = 10;
    private WebDriver selenium;
    private Configuration cfg;
    private String pageMarker;
    private Random randMarkerGenerator;

    public WicketSelenium(Configuration cfg, WebDriver selenium) {
        this.selenium = selenium;
        this.cfg = cfg;
        this.randMarkerGenerator = new Random();
        this.configToWaitOnNotFound();
    }

    private void configToWaitOnNotFound() {
        this.selenium.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        LOGGER.debug("Setting the implicit wait timeout to {}", (Object)10);
    }

    public void subscribeAjaxDoneHandler() {
        JavascriptExecutor jsExec = (JavascriptExecutor)this.selenium;
        String defineAjaxDoneIndicatorExpr = "if (typeof wicketPageTestAjaxDone === 'undefined') { var wicketPageTestAjaxDone = false;Wicket.Event.subscribe('/ajax/call/complete', function(jqEvent, attributes, jqXHR, errorThrown, textStatus) { window.wicketPageTestAjaxDone = true; }); }";
        jsExec.executeScript(defineAjaxDoneIndicatorExpr, new Object[0]);
    }

    private void clearAjaxDoneIndicator() {
        JavascriptExecutor jsExec = (JavascriptExecutor)this.selenium;
        jsExec.executeScript("window.wicketPageTestAjaxDone = false;", new Object[0]);
    }

    public void waitUntilAjaxDone() {
        new WebDriverWait(this.selenium, 10L).until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                JavascriptExecutor jsExec = (JavascriptExecutor)input;
                Boolean ajaxDone = (Boolean)jsExec.executeScript("return window.wicketPageTestAjaxDone == true;", new Object[0]);
                return ajaxDone;
            }
        });
        this.clearAjaxDoneIndicator();
    }

    public void setResponsePageMarker() {
        this.setResponsePageMarker(Long.toString(this.randMarkerGenerator.nextLong()));
    }

    public void setResponsePageMarker(String marker) {
        this.pageMarker = marker;
        PageMarkingListener pml = this.findPageMarkingListener();
        LOGGER.debug("Setting page marker to {}", (Object)this.pageMarker);
        pml.setMarker(this.pageMarker);
    }

    private PageMarkingListener findPageMarkingListener() {
        for (IRequestCycleListener l : Application.get().getRequestCycleListeners()) {
            if (!(l instanceof PageMarkingListener)) continue;
            PageMarkingListener pml = (PageMarkingListener)l;
            return pml;
        }
        throw new RuntimeException(PageMarkingListener.class.getSimpleName() + " not found. Have you installed it in your Wicket application?");
    }

    public void waitForMarkedPage() {
        if (this.pageMarker == null) {
            throw new RuntimeException("Must call setPageMarker() before calling this method");
        }
        new WebDriverWait(this.selenium, 10L).until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                Cookie marker = input.manage().getCookieNamed("wptPageMarker");
                if (marker != null) {
                    LOGGER.debug("Marker retrieved is {}", (Object)marker.getValue());
                    if (marker.getValue().equals(WicketSelenium.this.pageMarker)) {
                        LOGGER.debug("Marker matched. Clearing it.");
                        WicketSelenium.this.pageMarker = null;
                        return true;
                    }
                    LOGGER.debug("Marker not matched");
                    return false;
                }
                LOGGER.debug("No marker found");
                return false;
            }
        });
    }

    public void openBookmarkablePage(Class<? extends Page> pageClass) {
        this.selenium.get(this.getWicketAppBase() + String.format("wicket/bookmarkable/%s", pageClass.getName()));
    }

    public void openMountedPage(String mountPoint, PageParameters parameters) {
        String appBase = this.getWicketAppBase();
        String fullQuery = this.getFullQueryString(parameters);
        String url = fullQuery.isEmpty() ? appBase + mountPoint : appBase + mountPoint + "?" + fullQuery;
        this.selenium.get(url);
    }

    private String getFullQueryString(PageParameters parameters) {
        ArrayList<String> queries = new ArrayList<String>();
        Set keys = parameters.getNamedKeys();
        for (String key : keys) {
            queries.add(String.format("%s=%s", key, parameters.get(key).toString()));
        }
        String fullQuery = "";
        if (queries.size() == 1) {
            fullQuery = (String)queries.get(0);
        }
        if (queries.size() > 1) {
            fullQuery = (String)queries.get(0);
            for (int i = 1; i < queries.size(); ++i) {
                fullQuery = fullQuery + "&" + (String)queries.get(i);
            }
        }
        return fullQuery;
    }

    private String getWicketAppBase() {
        return String.format("http://localhost:%d/%s", this.cfg.getJettyServerPort(), this.cfg.getWicketFilterPrefix().trim().isEmpty() ? "" : this.cfg.getWicketFilterPrefix() + "/");
    }

    public void openHomePage() {
        this.selenium.get(this.getWicketAppBase());
    }

    public void openNonBookmarkablePage(Class<? extends Page> pageClass, Object ... constructorArgs) {
        MockableBeanInjector.mockBean((String)"pageFactory", (Object)new DefaultPageFactory(pageClass, constructorArgs));
        this.openBookmarkablePage(LauncherPage.class);
    }

    public void openComponent(ComponentFactory factory) {
        this.openNonBookmarkablePage(ComponentTestPage.class, factory);
    }

    public void openBreadCrumbPanel(IBreadCrumbPanelFactory factory) {
        this.openNonBookmarkablePage(BreadCrumbPanelTestPage.class, factory);
    }

    public WebElement findWicketElement(String path) {
        return this.findElement(new ByWicketIdPathFastVersion(path));
    }

    public WebElement findElement(By locator) {
        return this.selenium.findElement(locator);
    }

    public WebDriver getSelenium() {
        return this.selenium;
    }

    public String getText(By elementLocator) {
        return this.findElement(elementLocator).getText();
    }

    public String getValue(By elementLocator) {
        return this.findElement(elementLocator).getAttribute("value");
    }

    public void click(By elementLocator) {
        this.findElement(elementLocator).click();
    }

    public void sendKeys(By elementLocator, CharSequence ... keysToSend) {
        this.findElement(elementLocator).sendKeys(keysToSend);
    }

    public void clear(By elementLocator) {
        this.findElement(elementLocator).clear();
    }

    public void setPreferredLocale(Locale locale) {
        this.openNonBookmarkablePage(SwitchLocalePage.class, locale);
    }

    public void switchDefaultLocale() {
        this.openNonBookmarkablePage(SwitchLocalePage.class, Locale.getDefault());
    }
}

