/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import com.ttdev.wicketpagetest.Configuration;
import com.ttdev.wicketpagetest.WicketSelenium;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WicketSeleniumDriver
extends WicketSelenium {
    public WicketSeleniumDriver(Configuration cfg, WebDriver selenium) {
        super(cfg, selenium);
    }

    public void click(String wicketPath) {
        this.findWicketElement(wicketPath).click();
    }

    public void clear(String wicketPath) {
        this.findWicketElement(wicketPath).clear();
    }

    public void sendKeys(String wicketPath, CharSequence ... keysToSend) {
        this.findWicketElement(wicketPath).sendKeys(keysToSend);
    }

    public String getText(String wicketPath) {
        return this.findWicketElement(wicketPath).getText();
    }

    public String getValue(String wicketPath) {
        return this.getAttribute(wicketPath, "value");
    }

    public String getAttribute(String wicketPath, String attrName) {
        return this.findWicketElement(wicketPath).getAttribute(attrName);
    }

    public void wait(ExpectedCondition<?> condition) {
        try {
            new WebDriverWait(this.getSelenium(), 10L).until(condition);
        }
        catch (StaleElementReferenceException e) {
            this.wait(condition);
        }
    }

    public void waitUntilElementVisible(final String wicketPath) {
        this.wait(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WicketSeleniumDriver.this.isElementVisible(wicketPath);
            }
        });
    }

    public void waitUntilAttributeChanged(final String wicketPath, final String attrName, final String changeTo) {
        this.wait(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WicketSeleniumDriver.this.getAttribute(wicketPath, attrName).equals(changeTo);
            }
        });
    }

    public void waitUntilTextChanged(final String wicketPath, final String changeTo) {
        this.wait(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WicketSeleniumDriver.this.getText(wicketPath).equals(changeTo);
            }
        });
    }

    public boolean isElementPresent(String wicketPath) {
        try {
            this.findWicketElement(wicketPath);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean isElementVisible(String wicketPath) {
        return this.findWicketElement(wicketPath).isDisplayed();
    }

    public void mouseMoveOver(String wicketPath) {
        WebElement targetElement = this.findWicketElement(wicketPath);
        Actions builder = new Actions(this.getSelenium());
        builder.moveToElement(targetElement).build().perform();
    }
}

