/*
 * Decompiled with CFR 0.152.
 */
package com.ttdev.wicketpagetest;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

public class WicketWebElement {
    private WicketWebElement parent;
    private int depth;
    private WebElement element;
    private List<WicketWebElement> children = new ArrayList<WicketWebElement>();

    public WicketWebElement() {
        this(null);
    }

    public WicketWebElement(WebElement element) {
        this.element = element;
        this.depth = element == null ? 0 : element.getAttribute("wicketpath").split("_").length;
    }

    public WicketWebElement getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setParent(WicketWebElement parent) {
        this.parent = parent;
    }

    public void add(WicketWebElement child) {
        this.children.add(child);
        child.setParent(this);
    }

    public WicketWebElement findParent(WicketWebElement element) {
        if (this.parent == null) {
            return this;
        }
        if (this.depth == element.depth) {
            return this.parent;
        }
        if (this.depth < element.depth) {
            return this;
        }
        return this.parent.findParent(element);
    }

    public WebElement getElement() {
        return this.element;
    }

    public List<WicketWebElement> getChildren() {
        return this.children;
    }
}

