/*
 * Decompiled with CFR 0.152.
 */
package com.tunjid.androidx.navigation;

import com.tunjid.androidx.navigation.MultiStackNavigator;
import com.tunjid.androidx.savedstate.LifecycleSavedStateContainer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/tunjid/androidx/navigation/MultiStackVisitor;", "", "backStackType", "Lcom/tunjid/androidx/navigation/MultiStackNavigator$BackStackType;", "container", "Lcom/tunjid/androidx/savedstate/LifecycleSavedStateContainer;", "(Lcom/tunjid/androidx/navigation/MultiStackNavigator$BackStackType;Lcom/tunjid/androidx/savedstate/LifecycleSavedStateContainer;)V", "delegate", "", "", "currentHost", "hosts", "", "leave", "", "leaveAll", "", "previousHost", "()Ljava/lang/Integer;", "saveState", "visit", "value", "com.tunjid.androidx.navigation"})
public final class MultiStackVisitor {
    private final List<Integer> delegate;
    private final MultiStackNavigator.BackStackType backStackType;
    private final LifecycleSavedStateContainer container;

    public final void visit(int value) {
        List<Integer> list = this.delegate;
        boolean bl = false;
        boolean bl2 = false;
        List<Integer> $this$run = list;
        boolean bl3 = false;
        MultiStackNavigator.BackStackType backStackType = this.backStackType;
        if (backStackType instanceof MultiStackNavigator.BackStackType.Restricted) {
            if ($this$run.size() + 1 > ((MultiStackNavigator.BackStackType.Restricted)this.backStackType).getCount()) {
                CollectionsKt.removeFirst($this$run);
            }
        } else if (Intrinsics.areEqual((Object)backStackType, (Object)MultiStackNavigator.BackStackType.UniqueEntries.INSTANCE)) {
            $this$run.remove((Object)value);
        } else if (Intrinsics.areEqual((Object)backStackType, (Object)MultiStackNavigator.BackStackType.Unlimited.INSTANCE)) {
            // empty if block
        }
        $this$run.add(value);
        this.saveState();
    }

    public final boolean leave() {
        boolean willLeave;
        List<Integer> list = this.delegate;
        boolean bl = false;
        boolean bl2 = false;
        List<Integer> $this$run = list;
        boolean bl3 = false;
        boolean bl4 = willLeave = $this$run.size() > 1;
        if (willLeave) {
            CollectionsKt.removeLast($this$run);
            this.saveState();
        }
        return willLeave;
    }

    public final void leaveAll() {
        List<Integer> list = this.delegate;
        boolean bl = false;
        boolean bl2 = false;
        List<Integer> $this$run = list;
        boolean bl3 = false;
        $this$run.clear();
        $this$run.add(0);
        this.saveState();
    }

    public final int currentHost() {
        return ((Number)CollectionsKt.last(this.delegate)).intValue();
    }

    @NotNull
    public final int[] hosts() {
        return CollectionsKt.toIntArray((Collection)this.delegate);
    }

    @Nullable
    public final Integer previousHost() {
        List<Integer> list = this.delegate;
        boolean bl = false;
        boolean bl2 = false;
        List<Integer> $this$run = list;
        boolean bl3 = false;
        List<Integer> list2 = $this$run;
        int n = CollectionsKt.getLastIndex($this$run) - 1;
        boolean bl4 = false;
        return (Integer)CollectionsKt.getOrNull(list2, (int)n);
    }

    private final void saveState() {
        this.container.getSavedState().putIntArray("navState", this.hosts());
    }

    public MultiStackVisitor(@NotNull MultiStackNavigator.BackStackType backStackType, @NotNull LifecycleSavedStateContainer container) {
        Intrinsics.checkNotNullParameter((Object)backStackType, (String)"backStackType");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.backStackType = backStackType;
        this.container = container;
        if (this.backStackType instanceof MultiStackNavigator.BackStackType.Restricted && ((MultiStackNavigator.BackStackType.Restricted)this.backStackType).getCount() < 1) {
            throw (Throwable)new IllegalArgumentException("Restricted back stack size must be 1 or greater");
        }
        int[] nArray = this.container.getSavedState().getIntArray("navState");
        if (nArray == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"(container.savedState.ge\u2026        ?: intArrayOf(0))");
        this.delegate = ArraysKt.toMutableList((int[])nArray);
    }
}

