/*
 * Decompiled with CFR 0.152.
 */
package com.tuplejump.plugin;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.tuplejump.plugin.CassandraConnection;
import com.tuplejump.plugin.Evolutions$;
import com.tuplejump.plugin.Util$;
import play.api.Application;
import play.api.Configuration;
import play.api.Plugin;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u0013\ty1)Y:tC:$'/\u0019)mk\u001eLgN\u0003\u0002\u0004\t\u00051\u0001\u000f\\;hS:T!!\u0002\u0004\u0002\u0013Q,\b\u000f\\3kk6\u0004(\"A\u0004\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\t1!\u00199j\u0015\u0005)\u0012\u0001\u00029mCfL!a\u0006\n\u0003\rAcWoZ5o\u0011!I\u0002A!A!\u0002\u0013Q\u0012aA1qaB\u0011\u0011cG\u0005\u00039I\u00111\"\u00119qY&\u001c\u0017\r^5p]\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\"\u0001\t\u0012\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000bei\u0002\u0019\u0001\u000e\t\u000f\u0011\u0002\u0001\u0019!C\u0005K\u00059q\f[3ma\u0016\u0014X#\u0001\u0014\u0011\u0007-9\u0013&\u0003\u0002)\u0019\t1q\n\u001d;j_:\u0004\"!\t\u0016\n\u0005-\u0012!aE\"bgN\fg\u000e\u001a:b\u0007>tg.Z2uS>t\u0007bB\u0017\u0001\u0001\u0004%IAL\u0001\f?\",G\u000e]3s?\u0012*\u0017\u000f\u0006\u00020eA\u00111\u0002M\u0005\u0003c1\u0011A!\u00168ji\"91\u0007LA\u0001\u0002\u00041\u0013a\u0001=%c!1Q\u0007\u0001Q!\n\u0019\n\u0001b\u00185fYB,'\u000f\t\u0005\u0006o\u0001!\t\u0001O\u0001\u0007Q\u0016d\u0007/\u001a:\u0016\u0003%BQA\u000f\u0001\u0005Bm\nqa\u001c8Ti\u0006\u0014H\u000fF\u00010\u0011\u0015i\u0004\u0001\"\u0011<\u0003\u0019ygn\u0015;pa\")q\b\u0001C!\u0001\u00069QM\\1cY\u0016$W#A!\u0011\u0005-\u0011\u0015BA\"\r\u0005\u001d\u0011un\u001c7fC:\u0004")
public class CassandraPlugin
implements Plugin {
    private final Application app;
    private Option<CassandraConnection> _helper;

    private Option<CassandraConnection> _helper() {
        return this._helper;
    }

    private void _helper_$eq(Option<CassandraConnection> x$1) {
        this._helper = x$1;
    }

    public CassandraConnection helper() {
        return (CassandraConnection)this._helper().getOrElse((Function0)new Serializable(this){

            public final Nothing$ apply() {
                throw new RuntimeException("CassandraPlugin error: CassandraHelper initialization failed");
            }
        });
    }

    public void onStart() {
        Configuration appConfig = (Configuration)this.app.configuration().getConfig("cassandraPlugin").get();
        String appName = (String)appConfig.getString("appName", appConfig.getString$default$2()).getOrElse((Function0)new Serializable(this){

            public final String apply() {
                return "appWithCassandraPlugin";
            }
        });
        boolean isEvolutionEnabled = BoxesRunTime.unboxToBoolean((Object)appConfig.getBoolean("evolution.enabled").getOrElse((Function0)new Serializable(this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        String scriptSource = (String)appConfig.getString("evolution.directory", appConfig.getString$default$2()).getOrElse((Function0)new Serializable(this){

            public final String apply() {
                return "evolutions/cassandra/";
            }
        });
        String[] hosts = (String[])Predef$.MODULE$.refArrayOps((Object[])((String)appConfig.getString("host", appConfig.getString$default$2()).getOrElse((Function0)new Serializable(this){

            public final String apply() {
                return "localhost";
            }
        })).split(",")).map((Function1)new Serializable(this){

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        int port = BoxesRunTime.unboxToInt((Object)appConfig.getInt("port").getOrElse((Function0)new Serializable(this){

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 9042;
            }
        }));
        Cluster cluster = Cluster.builder().addContactPoints(hosts).withPort(port).build();
        this._helper_$eq((Option<CassandraConnection>)this.liftedTree1$1(appName, isEvolutionEnabled, scriptSource, hosts, port, cluster));
    }

    public void onStop() {
        this.helper().session().close();
        this.helper().cluster().close();
    }

    public boolean enabled() {
        return true;
    }

    private final Option liftedTree1$1(String appName$1, boolean isEvolutionEnabled$1, String scriptSource$1, String[] hosts$1, int port$1, Cluster cluster$1) {
        try {
            Session session = cluster$1.connect();
            Util$.MODULE$.loadScript("cassandraPlugin.cql", session);
            Object object = isEvolutionEnabled$1 ? BoxesRunTime.boxToBoolean((boolean)Evolutions$.MODULE$.applyEvolution(session, appName$1, scriptSource$1)) : BoxedUnit.UNIT;
            return new Some((Object)new CassandraConnection(hosts$1, port$1, cluster$1, session));
        }
        catch (NoHostAvailableException noHostAvailableException) {
            String msg = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initialize CassandraPlugin.\n             |Please check if Cassandra is accessible at\n             | ", ":", " or update configuration"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])hosts$1).head(), BoxesRunTime.boxToInteger((int)port$1)})))).stripMargin();
            Configuration qual$1 = this.app.configuration();
            String x$3 = msg;
            Option x$4 = qual$1.globalError$default$2();
            throw qual$1.globalError(x$3, x$4);
        }
    }

    public CassandraPlugin(Application app) {
        this.app = app;
        Plugin.class.$init$((Plugin)this);
        this._helper = None$.MODULE$;
    }
}

