/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfRow;
import com.tutego.jrtf.RtfText;
import com.tutego.jrtf.RtfTextPara;
import java.io.IOException;
import java.util.ArrayList;

public abstract class RtfPara {
    abstract void rtf(Appendable var1, boolean var2) throws IOException;

    public static RtfTextPara p(Object ... texts) {
        return RtfPara.p(RtfText.text(texts));
    }

    public static RtfTextPara p(final RtfText ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfTextPara(){

                @Override
                void rtf(Appendable out, boolean withEndingPar) throws IOException {
                    out.append("\\par");
                }
            };
        }
        return new RtfTextPara(){

            @Override
            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{");
                out.append(this.textparFormatRtf());
                for (RtfText rtfText : texts) {
                    rtfText.rtf(out);
                }
                if (withEndingPar) {
                    out.append("\\par");
                }
                out.append("}\n");
            }
        };
    }

    public static RtfTextPara pard(final RtfText ... texts) {
        if (texts == null || texts.length == 0) {
            return new RtfTextPara(){

                @Override
                void rtf(Appendable out, boolean withEndingPar) throws IOException {
                    out.append("\\pard\\par");
                }
            };
        }
        return new RtfTextPara(){

            @Override
            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\pard");
                out.append(this.textparFormatRtf());
                for (RtfText rtfText : texts) {
                    rtfText.rtf(out);
                }
                if (withEndingPar) {
                    out.append("\\par");
                }
                out.append("}\n");
            }
        };
    }

    public static RtfPara ul(String text) {
        return RtfPara.ul(new RtfText(text));
    }

    public static RtfPara ul(final RtfText text) {
        String s = "{\\pard{\\pntext\\bullet\\tab}{\\*\\pn\\pnlvlblt\\pnf1\\pnindent0{\\pntxtb\\bullet}}\\fi-200\\li200 ";
        return new RtfPara(){

            @Override
            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\pard{\\pntext\\bullet\\tab}{\\*\\pn\\pnlvlblt\\pnf1\\pnindent0{\\pntxtb\\bullet}}\\fi-200\\li200 ");
                text.rtf(out);
                out.append('}');
            }
        };
    }

    public static RtfRow row(RtfText ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        ArrayList<RtfTextPara> paras = new ArrayList<RtfTextPara>();
        for (RtfText cell : cells) {
            paras.add(RtfPara.p(cell));
        }
        RtfPara[] parasArray = new RtfPara[paras.size()];
        return RtfPara.row(paras.toArray(parasArray));
    }

    public static RtfRow row(Object ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        ArrayList<RtfPara> paras = new ArrayList<RtfPara>();
        for (Object cell : cells) {
            if (cell instanceof RtfPara) {
                paras.add((RtfPara)cell);
                continue;
            }
            paras.add(RtfPara.p(cell));
        }
        RtfPara[] parasArray = new RtfPara[paras.size()];
        return RtfPara.row(paras.toArray(parasArray));
    }

    public static RtfRow row(final RtfPara ... cells) {
        if (cells == null) {
            throw new RtfException("There has to be at least one cell in a row");
        }
        return new RtfRow(){

            @Override
            void rtf(Appendable out, boolean withEndingPar) throws IOException {
                out.append("{\\trowd\\trautofit1\\intbl\n");
                for (int i = 1; i <= cells.length; ++i) {
                    out.append(this.tbldef).append(cells[i - 1] instanceof RtfTextPara ? ((RtfTextPara)cells[i - 1]).cellfmt : "").append("\\cellx").append(Integer.toString(i)).append("\n");
                }
                for (RtfPara cell : cells) {
                    cell.rtf(out, false);
                    out.append("\\cell\n");
                }
                out.append("\\row}");
            }
        };
    }
}

