/*
 * Decompiled with CFR 0.152.
 */
package com.tutego.jrtf;

import com.tutego.jrtf.RtfException;
import com.tutego.jrtf.RtfText;
import com.tutego.jrtf.RtfUnit;
import java.io.IOException;
import java.io.InputStream;

public class RtfPicture {
    private final StringBuilder hexPicData = new StringBuilder(4096);
    private int widthInTwips = -1;
    private int heightInTwips = -1;
    private int scaleX = -1;
    private int scaleY = -1;

    RtfPicture(InputStream source) throws IOException {
        int b;
        if (source == null) {
            throw new IllegalArgumentException("Image source can't be null");
        }
        int pos = 1;
        while ((b = source.read()) != -1) {
            String hexString = Integer.toHexString(b);
            if (hexString.length() == 1) {
                this.hexPicData.append('0').append(hexString);
            } else {
                this.hexPicData.append(hexString);
            }
            if (pos++ != 40) continue;
            pos = 1;
            this.hexPicData.append('\n');
        }
    }

    public RtfPicture width(double width, RtfUnit unit) {
        this.widthInTwips = unit.toTwips(width);
        return this;
    }

    public RtfPicture height(double height, RtfUnit unit) {
        this.heightInTwips = unit.toTwips(height);
        return this;
    }

    public RtfPicture size(double width, double height, RtfUnit unit) {
        this.widthInTwips = unit.toTwips(width);
        this.heightInTwips = unit.toTwips(height);
        return this;
    }

    public RtfPicture scaleX(int scale) {
        this.scaleX = scale;
        return this;
    }

    public RtfPicture scaleY(int scale) {
        this.scaleY = scale;
        return this;
    }

    public RtfPicture scale(int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        return this;
    }

    public RtfText type(final PictureType pictureType) {
        return new RtfText(null){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            void rtf(Appendable out) throws IOException {
                out.append("{\\pict");
                if (pictureType == PictureType.AUTOMATIC) {
                    String hexChar1 = RtfPicture.this.hexPicData.substring(2, 4);
                    String hexChar2 = RtfPicture.this.hexPicData.substring(4, 6);
                    String hexChar3 = RtfPicture.this.hexPicData.substring(6, 8);
                    String hexChar6 = RtfPicture.this.hexPicData.substring(12, 14);
                    String hexChar7 = RtfPicture.this.hexPicData.substring(14, 16);
                    String hexChar8 = RtfPicture.this.hexPicData.substring(16, 18);
                    String hexChar9 = RtfPicture.this.hexPicData.substring(18, 20);
                    char char1 = (char)Integer.parseInt(hexChar1, 16);
                    char char2 = (char)Integer.parseInt(hexChar2, 16);
                    char char3 = (char)Integer.parseInt(hexChar3, 16);
                    char char6 = (char)Integer.parseInt(hexChar6, 16);
                    char char7 = (char)Integer.parseInt(hexChar7, 16);
                    char char8 = (char)Integer.parseInt(hexChar8, 16);
                    char char9 = (char)Integer.parseInt(hexChar9, 16);
                    if (char6 == 'J' && char7 == 'F' && char8 == 'I' && char9 == 'F') {
                        out.append(PictureType.JPG.toString());
                    } else {
                        if (char1 != 'P' || char2 != 'N' || char3 != 'G') throw new RtfException("Unsupported image type");
                        out.append(PictureType.PNG.toString());
                    }
                } else {
                    out.append(pictureType.toString());
                }
                if (RtfPicture.this.widthInTwips != -1) {
                    out.append("\\picwgoal").append(Integer.toString(RtfPicture.this.widthInTwips));
                }
                if (RtfPicture.this.heightInTwips != -1) {
                    out.append("\\pichgoal").append(Integer.toString(RtfPicture.this.heightInTwips));
                }
                if (RtfPicture.this.scaleX != -1) {
                    out.append("\\picscalex").append(Integer.toString(RtfPicture.this.scaleX));
                }
                if (RtfPicture.this.scaleY != -1) {
                    out.append("\\picscaley").append(Integer.toString(RtfPicture.this.scaleY));
                }
                out.append('\n');
                out.append(RtfPicture.this.hexPicData);
                out.append('}');
            }
        };
    }

    public static enum PictureType {
        AUTOMATIC,
        JPG{

            public String toString() {
                return "\\jpegblip";
            }
        }
        ,
        PNG{

            public String toString() {
                return "\\pngblip";
            }
        };

    }
}

