/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.iff.BMHDChunk;
import com.twelvemonkeys.imageio.plugins.iff.CAMGChunk;
import com.twelvemonkeys.imageio.plugins.iff.GenericChunk;
import com.twelvemonkeys.imageio.plugins.iff.IFFUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.IndexColorModel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;

final class IFFImageMetadata
extends AbstractMetadata {
    private final int formType;
    private final BMHDChunk header;
    private final IndexColorModel colorMap;
    private final CAMGChunk viewPort;
    private final List<GenericChunk> meta;

    IFFImageMetadata(int n, BMHDChunk bMHDChunk, IndexColorModel indexColorModel, CAMGChunk cAMGChunk, List<GenericChunk> list) {
        this.formType = (Integer)Validate.isTrue((boolean)this.validFormType(n), (Object)n, (String)"Unknown IFF Form type: %s");
        this.header = (BMHDChunk)Validate.notNull((Object)bMHDChunk, (String)"header");
        this.colorMap = indexColorModel;
        this.viewPort = cAMGChunk;
        this.meta = list;
    }

    private boolean validFormType(int n) {
        switch (n) {
            case 1094926925: 
            case 0x44454550: 
            case 1229734477: 
            case 1346522400: 
            case 1380401720: 
            case 1380401742: {
                return true;
            }
        }
        return false;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        switch (this.header.bitplanes) {
            case 8: {
                if (this.colorMap == null) {
                    iIOMetadataNode2.setAttribute("name", "GRAY");
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 32: {
                iIOMetadataNode2.setAttribute("name", "RGB");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("name", "Unknown");
            }
        }
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        if (this.colorMap == null && this.header.bitplanes == 8) {
            iIOMetadataNode3.setAttribute("value", Integer.toString(1));
        } else if (this.header.bitplanes == 32) {
            iIOMetadataNode3.setAttribute("value", Integer.toString(4));
        } else {
            iIOMetadataNode3.setAttribute("value", Integer.toString(3));
        }
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        iIOMetadataNode4.setAttribute("value", "TRUE");
        if (this.colorMap != null) {
            IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("Palette");
            iIOMetadataNode.appendChild(iIOMetadataNode5);
            for (int i = 0; i < this.colorMap.getMapSize(); ++i) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode5.appendChild(iIOMetadataNode6);
                iIOMetadataNode6.setAttribute("index", Integer.toString(i));
                iIOMetadataNode6.setAttribute("red", Integer.toString(this.colorMap.getRed(i)));
                iIOMetadataNode6.setAttribute("green", Integer.toString(this.colorMap.getGreen(i)));
                iIOMetadataNode6.setAttribute("blue", Integer.toString(this.colorMap.getBlue(i)));
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        if (this.header.compressionType == 0) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "RLE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
        iIOMetadataNode3.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        switch (this.formType) {
            case 1346522400: {
                iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
                break;
            }
            case 1229734477: {
                iIOMetadataNode2.setAttribute("value", "PlaneInterleaved");
                break;
            }
            default: {
                iIOMetadataNode2.setAttribute("value", "Unknown " + IFFUtil.toChunkStr(this.formType));
            }
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode3.setAttribute("value", this.colorMap != null ? "Index" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("BitsPerSample");
        String string = this.bitsPerSampleValue(this.header.bitplanes);
        iIOMetadataNode4.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    private String bitsPerSampleValue(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Integer.toString(n);
            }
            case 24: {
                return "8 8 8";
            }
            case 32: {
                return "8 8 8 8";
            }
        }
        throw new IllegalArgumentException("Ubknown bit count: " + n);
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        if (this.viewPort == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        iIOMetadataNode2.setAttribute("value", String.valueOf((this.viewPort.isHires() ? 2.0f : 1.0f) / (this.viewPort.isLaced() ? 2.0f : 1.0f)));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2.setAttribute("value", "1.0");
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        if (this.meta.isEmpty()) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        for (GenericChunk genericChunk : this.meta) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", IFFUtil.toChunkStr(genericChunk.chunkId));
            iIOMetadataNode2.setAttribute("value", new String(genericChunk.data, genericChunk.chunkId == 1431586360 ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode;
        if (!(this.colorMap != null && this.colorMap.hasAlpha() || this.header.bitplanes == 32)) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Transparency");
        if (this.header.bitplanes == 32) {
            iIOMetadataNode = new IIOMetadataNode("Alpha");
            iIOMetadataNode.setAttribute("value", "nonpremultiplied");
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        if (this.colorMap != null && this.colorMap.getTransparency() == 2) {
            iIOMetadataNode = new IIOMetadataNode("TransparentIndex");
            iIOMetadataNode.setAttribute("value", Integer.toString(this.colorMap.getTransparentPixel()));
            iIOMetadataNode2.appendChild(iIOMetadataNode);
        }
        return iIOMetadataNode2;
    }
}

