/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.PICTImageReader;
import com.twelvemonkeys.imageio.plugins.pict.PICTProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PICTImageReaderSpi
extends ImageReaderSpiBase {
    public PICTImageReaderSpi() {
        super((ReaderWriterProviderInfo)new PICTProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            if (this.isPICT(imageInputStream)) {
                boolean bl = true;
                return bl;
            }
            imageInputStream.reset();
            imageInputStream.mark();
            PICTImageReaderSpi.skipNullHeader(imageInputStream);
            boolean bl = this.isPICT(imageInputStream);
            return bl;
        }
        catch (EOFException eOFException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    static void skipNullHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.skipBytes(512);
    }

    private boolean isPICT(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.readUnsignedShort();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        if (n4 - n2 < 0 || n3 - n < 0) {
            return false;
        }
        int n5 = imageInputStream.readInt();
        return (n5 & 0xFFFF0000) == 0x11010000 || n5 == 1114879;
    }

    public ImageReader createReaderInstance(Object object) {
        return new PICTImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Apple Mac Paint Picture (PICT) image reader";
    }
}

