/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.QTDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

final class QTGenericDecompressor
extends QTDecompressor {
    QTGenericDecompressor() {
    }

    @Override
    public boolean canDecompress(QuickTime.ImageDesc imageDesc) {
        return true;
    }

    @Override
    public BufferedImage decompress(QuickTime.ImageDesc imageDesc, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return this.readUsingFormatName(imageDesc.compressorIdentifer.trim(), inputStream);
        }
        return bufferedImage;
    }

    /*
     * Loose catch block
     */
    private BufferedImage readUsingFormatName(String string, InputStream inputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    return bufferedImage;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                imageReader.dispose();
            }
        }
        return null;
    }
}

