/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.PNMImageReader;
import com.twelvemonkeys.imageio.plugins.pnm.PNMProviderInfo;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PNMImageReaderSpi
extends ImageReaderSpi {
    public PNMImageReaderSpi() {
        this(new PNMProviderInfo());
    }

    private PNMImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"pnm", "pbm", "pgm", "ppm", "pam", "pfm", "PNM", "PBM", "PGM", "PPM", "PAM", "PFM"}, new String[]{"pbm", "pgm", "ppm", "pam", "pfm"}, new String[]{"image/x-portable-pixmap", "image/x-portable-anymap", "image/x-portable-arbitrarymap"}, "com.twelvemonkeys.imageio.plugins.pnm.PNMImageReader", new Class[]{ImageInputStream.class}, new String[]{"com.twelvemonkeys.imageio.plugins.pnm.PNMImageWriterSpi", "com.twelvemonkeys.imageio.plugins.pnm.PAMImageWriterSpi"}, true, null, null, null, null, true, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            short s = imageInputStream.readShort();
            switch (s) {
                case 20529: 
                case 20530: 
                case 20531: 
                case 20532: 
                case 20533: 
                case 20534: 
                case 20550: 
                case 20582: {
                    boolean bl = true;
                    return bl;
                }
                case 20535: {
                    boolean bl = imageInputStream.readInt() != 0x20333332;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new PNMImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "NetPBM Portable Any Map (PNM and PAM) image reader";
    }
}

