/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.HeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.TupleType;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageInputStream;

final class PNMHeaderParser
extends HeaderParser {
    private final short fileType;
    private final TupleType tupleType;

    public PNMHeaderParser(ImageInputStream imageInputStream, short s) {
        super(imageInputStream);
        this.fileType = s;
        this.tupleType = PNMHeaderParser.asTupleType(s);
    }

    static TupleType asTupleType(int n) {
        switch (n) {
            case 20529: 
            case 20532: {
                return TupleType.BLACKANDWHITE_WHITE_IS_ZERO;
            }
            case 20530: 
            case 20533: {
                return TupleType.GRAYSCALE;
            }
            case 20531: 
            case 20534: {
                return TupleType.RGB;
            }
        }
        throw new AssertionError((Object)("Illegal PNM type :" + n));
    }

    @Override
    public PNMHeader parse() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = this.tupleType == TupleType.BLACKANDWHITE_WHITE_IS_ZERO ? 1 : 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while (n == 0 || n2 == 0 || n3 == 0) {
            String string;
            stringBuilder.delete(0, stringBuilder.length());
            while (stringBuilder.length() < 16) {
                byte by = this.input.readByte();
                if (by == 35) {
                    String string2 = PNMHeaderParser.readLineUTF8(this.input).trim();
                    if (string2.isEmpty()) break;
                    arrayList.add(string2);
                    break;
                }
                if (Character.isWhitespace((char)by)) {
                    if (stringBuilder.length() <= 0) continue;
                    break;
                }
                stringBuilder.append((char)by);
            }
            if ((string = stringBuilder.toString().trim()).isEmpty()) continue;
            if (n == 0) {
                n = Integer.parseInt(string);
                continue;
            }
            if (n2 == 0) {
                n2 = Integer.parseInt(string);
                continue;
            }
            n3 = Integer.parseInt(string);
        }
        return new PNMHeader(this.fileType, this.tupleType, n, n2, this.tupleType.getSamplesPerPixel(), n3, arrayList);
    }

    private static String readLineUTF8(ImageInputStream imageInputStream) throws IOException {
        int n;
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(128);
        do {
            n = imageInputStream.read();
            switch (n) {
                case 13: {
                    if (imageInputStream.read() != 10) {
                        imageInputStream.seek(imageInputStream.getStreamPosition() - 1L);
                    }
                }
                case -1: 
                case 10: {
                    n = -1;
                    break;
                }
                default: {
                    fastByteArrayOutputStream.write(n);
                }
            }
        } while (n != -1);
        return fastByteArrayOutputStream.toString("UTF8");
    }
}

