/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.plugins.pnm.HeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.PNMMetadata;
import com.twelvemonkeys.imageio.plugins.pnm.Plain16BitDecoder;
import com.twelvemonkeys.imageio.plugins.pnm.Plain1BitDecoder;
import com.twelvemonkeys.imageio.plugins.pnm.Plain8BitDecoder;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.imageio.util.RasterUtils;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PNMImageReader
extends ImageReaderBase {
    private PNMHeader header;

    PNMImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.imageInput.setByteOrder(ByteOrder.BIG_ENDIAN);
            this.header = HeaderParser.parse(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
            this.imageInput.setByteOrder(this.header.getByteOrder());
        } else {
            this.imageInput.seek(this.imageInput.getFlushedPosition());
        }
    }

    static String asASCII(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        int n2 = this.header.getBitsPerSample();
        int n3 = this.header.getTransferType();
        int n4 = this.header.getSamplesPerPixel();
        boolean bl = this.header.getTransparency() != 1;
        switch (this.header.getTupleType()) {
            case BLACKANDWHITE_WHITE_IS_ZERO: 
            case BLACKANDWHITE_ALPHA: 
            case GRAYSCALE_ALPHA: 
            case BLACKANDWHITE: 
            case GRAYSCALE: {
                if (this.header.getMaxSample() <= 65535) {
                    return bl ? ImageTypeSpecifiers.createGrayscale((int)n2, (int)n3, (boolean)false) : ImageTypeSpecifiers.createGrayscale((int)n2, (int)n3);
                }
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])this.createBandOffsets(n4), (int)n3, (boolean)bl, (boolean)false);
            }
            case RGB: 
            case RGB_ALPHA: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])this.createBandOffsets(n4), (int)n3, (boolean)bl, (boolean)false);
            }
            case CMYK: 
            case CMYK_ALPHA: {
                ColorSpace colorSpace = ColorSpaces.getColorSpace((int)5001);
                return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])this.createBandOffsets(n4), (int)n3, (boolean)bl, (boolean)false);
            }
        }
        throw new AssertionError((Object)("Unknown PNM tuple type: " + (Object)((Object)this.header.getTupleType())));
    }

    private int[] createBandOffsets(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        switch (this.header.getTupleType()) {
            case RGB: {
                if (this.header.getTransferType() != 0) break;
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(5));
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(4));
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(1));
                break;
            }
            case RGB_ALPHA: {
                if (this.header.getTransferType() != 0) break;
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(6));
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(2));
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(3));
                arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(7));
            }
        }
        if (imageTypeSpecifier != null) {
            arrayList.add(imageTypeSpecifier);
        }
        return arrayList.iterator();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = PNMImageReader.getDestination((ImageReadParam)imageReadParam, iterator, (int)n2, (int)n3);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        PNMImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        WritableRaster writableRaster = imageTypeSpecifier.createBufferedImage(n2, 1).getRaster();
        Raster raster = this.clipRowToRect(writableRaster, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
        int n4 = writableRaster.getTransferType();
        int n5 = this.header.getSamplesPerPixel();
        byte[] byArray = null;
        short[] sArray = null;
        float[] fArray = null;
        switch (n4) {
            case 0: {
                byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                break;
            }
            case 1: {
                sArray = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
                break;
            }
            case 4: {
                fArray = ((DataBufferFloat)writableRaster.getDataBuffer()).getData();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported transfer type: " + n4));
            }
        }
        WritableRaster writableRaster2 = n4 == 0 ? RasterUtils.asByteRaster((WritableRaster)bufferedImage.getRaster()) : bufferedImage.getRaster();
        writableRaster2 = this.clipToRect(writableRaster2, rectangle2, imageReadParam != null ? imageReadParam.getDestinationBands() : null);
        PNMImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)imageTypeSpecifier.getNumBands(), (int)writableRaster2.getNumBands());
        int n6 = imageReadParam == null ? 1 : imageReadParam.getSourceXSubsampling();
        int n7 = imageReadParam == null ? 1 : imageReadParam.getSourceYSubsampling();
        DataInput dataInput = this.wrapInput();
        this.processImageStarted(n);
        for (int i = 0; i < n3; ++i) {
            switch (n4) {
                case 0: {
                    this.readRowByte(writableRaster2, raster, byArray, this.header.getBitsPerSample(), n5, dataInput, i, rectangle, n6, n7);
                    break;
                }
                case 1: {
                    this.readRowUShort(writableRaster2, raster, sArray, n5, dataInput, i, rectangle, n6, n7);
                    break;
                }
                case 4: {
                    this.readRowFloat(writableRaster2, raster, fArray, n5, dataInput, i, rectangle, n6, n7);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported transfer type: " + n4));
                }
            }
            this.processImageProgress(100.0f * (float)i / (float)n3);
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            if (i >= rectangle.y + rectangle.height) break;
        }
        if (bufferedImage.isAlphaPremultiplied()) {
            imageTypeSpecifier.getColorModel().coerceData(writableRaster2, true);
        }
        this.processImageComplete();
        return bufferedImage;
    }

    private DataInput wrapInput() throws IIOException {
        switch (this.header.getFileType()) {
            case 20529: {
                return new DataInputStream(new Plain1BitDecoder(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput), this.header.getWidth() * this.header.getSamplesPerPixel()));
            }
            case 20530: 
            case 20531: {
                if (this.header.getBitsPerSample() <= 8) {
                    return new DataInputStream(new Plain8BitDecoder(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput)));
                }
                if (this.header.getBitsPerSample() <= 16) {
                    return new DataInputStream(new Plain16BitDecoder(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput)));
                }
                throw new IIOException("Unsupported bit depth for type: " + PNMImageReader.asASCII(this.header.getFileType()));
            }
            case 20532: 
            case 20533: 
            case 20534: 
            case 20535: 
            case 20550: 
            case 20582: {
                return this.imageInput;
            }
        }
        throw new AssertionError((Object)("Unknown input type: " + PNMImageReader.asASCII(this.header.getFileType())));
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readRowByte(WritableRaster writableRaster, Raster raster, byte[] byArray, int n, int n2, DataInput dataInput, int n3, Rectangle rectangle, int n4, int n5) throws IOException {
        if (n3 % n5 != 0 || n3 < rectangle.y || n3 >= rectangle.y + rectangle.height) {
            dataInput.skipBytes(byArray.length);
            return;
        }
        dataInput.readFully(byArray);
        IIOUtil.subsampleRow((byte[])byArray, (int)rectangle.x, (int)rectangle.width, (byte[])byArray, (int)0, (int)n2, (int)n, (int)n4);
        this.normalize(byArray, 0, byArray.length / n4);
        int n6 = (n3 - rectangle.y) / n5;
        writableRaster.setDataElements(0, n6, raster);
    }

    private void readRowUShort(WritableRaster writableRaster, Raster raster, short[] sArray, int n, DataInput dataInput, int n2, Rectangle rectangle, int n3, int n4) throws IOException {
        if (n2 % n4 != 0 || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) {
            dataInput.skipBytes(sArray.length * 2);
            return;
        }
        PNMImageReader.readFully(dataInput, sArray);
        IIOUtil.subsampleRow((short[])sArray, (int)rectangle.x, (int)rectangle.width, (short[])sArray, (int)0, (int)n, (int)16, (int)n3);
        this.normalize(sArray);
        int n5 = (n2 - rectangle.y) / n4;
        writableRaster.setDataElements(0, n5, raster);
    }

    private void readRowFloat(WritableRaster writableRaster, Raster raster, float[] fArray, int n, DataInput dataInput, int n2, Rectangle rectangle, int n3, int n4) throws IOException {
        if (n2 % n4 != 0 || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) {
            dataInput.skipBytes(fArray.length * 4);
            return;
        }
        PNMImageReader.readFully(dataInput, fArray);
        if (n3 > 1) {
            IIOUtil.subsampleRow((float[])fArray, (int)rectangle.x, (int)rectangle.width, (float[])fArray, (int)0, (int)n, (int)32, (int)n3);
        }
        this.normalize(fArray);
        int n5 = writableRaster.getHeight() - 1 - (n2 - rectangle.y) / n4;
        writableRaster.setDataElements(0, n5, raster);
    }

    private static void readFully(DataInput dataInput, short[] sArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ((ImageInputStream)dataInput).readFully(sArray, 0, sArray.length);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInput.readShort();
            }
        }
    }

    private static void readFully(DataInput dataInput, float[] fArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ((ImageInputStream)dataInput).readFully(fArray, 0, fArray.length);
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = dataInput.readFloat();
            }
        }
    }

    private void normalize(byte[] byArray, int n, int n2) {
        switch (this.header.getTupleType()) {
            case BLACKANDWHITE_ALPHA: 
            case BLACKANDWHITE: {
                break;
            }
            case BLACKANDWHITE_WHITE_IS_ZERO: {
                for (int i = n; i < n2; ++i) {
                    byArray[i] = ~byArray[i];
                }
                break;
            }
            case GRAYSCALE_ALPHA: 
            case GRAYSCALE: 
            case RGB: 
            case RGB_ALPHA: 
            case CMYK: 
            case CMYK_ALPHA: {
                for (int i = n; i < n2; ++i) {
                    byArray[i] = (byte)(byArray[i] * 255 / this.header.getMaxSample());
                }
                break;
            }
        }
    }

    private void normalize(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(sArray[i] * 65535 / this.header.getMaxSample());
        }
    }

    private void normalize(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Math.min(1.0f, fArray[i]);
        }
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return new PNMMetadata(this.header);
    }

    public static void main(String[] stringArray) throws IOException {
        PNMImageReader pNMImageReader = new PNMImageReader(null);
        for (String string : stringArray) {
            File file = new File(string);
            pNMImageReader.setInput(ImageIO.createImageInputStream(file));
            ImageReadParam imageReadParam = pNMImageReader.getDefaultReadParam();
            imageReadParam.setDestinationType(pNMImageReader.getImageTypes(0).next());
            PNMImageReader.showIt((BufferedImage)pNMImageReader.read(0, imageReadParam), (String)file.getName());
        }
    }
}

