/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.StandardImageMetadataSupport;
import com.twelvemonkeys.imageio.plugins.tga.TGAExtensions;
import com.twelvemonkeys.imageio.plugins.tga.TGAHeader;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageTypeSpecifier;

final class TGAMetadata
extends StandardImageMetadataSupport {
    TGAMetadata(ImageTypeSpecifier imageTypeSpecifier, TGAHeader tGAHeader, TGAExtensions tGAExtensions) {
        super(TGAMetadata.builder((ImageTypeSpecifier)imageTypeSpecifier).withCompressionTypeName(TGAMetadata.compressionName(tGAHeader)).withPixelAspectRatio(Double.valueOf(TGAMetadata.pixelAspectRatio(tGAExtensions))).withOrientation(TGAMetadata.orientation(tGAHeader)).withFormatVersion(tGAExtensions == null ? "1.0" : "2.0").withDocumentCreationTime(TGAMetadata.documentCreationTime(tGAExtensions)).withTextEntries(TGAMetadata.textEntries(tGAHeader, tGAExtensions)));
    }

    private static String compressionName(TGAHeader tGAHeader) {
        switch (tGAHeader.getImageType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "None";
            }
            case 9: 
            case 10: 
            case 11: {
                return "RLE";
            }
        }
        return "Unknown";
    }

    private static double pixelAspectRatio(TGAExtensions tGAExtensions) {
        return tGAExtensions != null ? tGAExtensions.getPixelAspectRatio() : 1.0;
    }

    private static StandardImageMetadataSupport.ImageOrientation orientation(TGAHeader tGAHeader) {
        switch (tGAHeader.origin) {
            case 0: {
                return StandardImageMetadataSupport.ImageOrientation.FlipH;
            }
            case 1: {
                return StandardImageMetadataSupport.ImageOrientation.Rotate180;
            }
            case 2: {
                return StandardImageMetadataSupport.ImageOrientation.Normal;
            }
            case 3: {
                return StandardImageMetadataSupport.ImageOrientation.FlipV;
            }
        }
        throw new IllegalArgumentException("Unknown orientation: " + tGAHeader.origin);
    }

    private static Calendar documentCreationTime(TGAExtensions tGAExtensions) {
        return tGAExtensions != null ? tGAExtensions.creationDate : null;
    }

    private static Map<String, String> textEntries(TGAHeader tGAHeader, TGAExtensions tGAExtensions) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        TGAMetadata.putIfValue(linkedHashMap, "DocumentName", tGAHeader.getIdentification());
        if (tGAExtensions != null) {
            TGAMetadata.putIfValue(linkedHashMap, "Software", tGAExtensions.getSoftwareVersion() == null ? tGAExtensions.getSoftware() : tGAExtensions.getSoftware() + " " + tGAExtensions.getSoftwareVersion());
            TGAMetadata.putIfValue(linkedHashMap, "Artist", tGAExtensions.getAuthorName());
            TGAMetadata.putIfValue(linkedHashMap, "UserComment", tGAExtensions.getAuthorComments());
        }
        return linkedHashMap;
    }

    private static void putIfValue(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.isEmpty()) {
            map.put(string, string2);
        }
    }
}

