/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.tga.RLEDecoder;
import com.twelvemonkeys.imageio.plugins.tga.TGA;
import com.twelvemonkeys.imageio.plugins.tga.TGAExtensions;
import com.twelvemonkeys.imageio.plugins.tga.TGAHeader;
import com.twelvemonkeys.imageio.plugins.tga.TGAImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.tga.TGAMetadata;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class TGAImageReader
extends ImageReaderBase {
    private TGAHeader header;
    private TGAExtensions extensions;

    protected TGAImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
        this.extensions = null;
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        switch (this.header.getImageType()) {
            case 1: 
            case 9: 
            case 32: 
            case 33: {
                return ImageTypeSpecifiers.createFromIndexColorModel((IndexColorModel)this.header.getColorMap());
            }
            case 3: 
            case 11: {
                return ImageTypeSpecifiers.createGrayscale((int)8, (int)0);
            }
            case 2: 
            case 10: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                boolean bl = this.header.getAttributeBits() > 0 && this.extensions != null && this.extensions.hasAlpha();
                boolean bl2 = this.extensions != null && this.extensions.isAlphaPremultiplied();
                switch (this.header.getPixelDepth()) {
                    case 16: {
                        if (bl) {
                            return ImageTypeSpecifiers.createPacked((ColorSpace)colorSpace, (int)31744, (int)992, (int)31, (int)32768, (int)1, (boolean)bl2);
                        }
                        return ImageTypeSpecifiers.createFromBufferedImageType((int)9);
                    }
                    case 24: {
                        return ImageTypeSpecifiers.createFromBufferedImageType((int)5);
                    }
                    case 32: {
                        return ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{2, 1, 0, 3}, (int)0, (boolean)true, (boolean)bl2);
                    }
                }
                throw new IIOException("Unknown pixel depth for truecolor: " + this.header.getPixelDepth());
            }
        }
        throw new IIOException("Unknown image type: " + this.header.getImageType());
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        int n2 = this.getWidth(n);
        int n3 = this.getHeight(n);
        BufferedImage bufferedImage = TGAImageReader.getDestination((ImageReadParam)imageReadParam, iterator, (int)n2, (int)n3);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        TGAImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n2, (int)n3, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        WritableRaster writableRaster = this.clipToRect(bufferedImage.getRaster(), rectangle2, imageReadParam != null ? imageReadParam.getDestinationBands() : null);
        TGAImageReader.checkReadParamBandSettings((ImageReadParam)imageReadParam, (int)imageTypeSpecifier.getNumBands(), (int)writableRaster.getNumBands());
        WritableRaster writableRaster2 = imageTypeSpecifier.createBufferedImage(n2, 1).getRaster();
        Raster raster = this.clipRowToRect(writableRaster2, rectangle, imageReadParam != null ? imageReadParam.getSourceBands() : null, imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1);
        int n4 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n5 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        this.processImageStarted(n);
        int n6 = this.header.getImageType();
        ImageInputStream imageInputStream = n6 == 9 || n6 == 10 || n6 == 11 ? new LittleEndianDataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput), (Decoder)new RLEDecoder(this.header.getPixelDepth()))) : this.imageInput;
        for (int i = 0; i < n3; ++i) {
            switch (this.header.getPixelDepth()) {
                case 8: 
                case 24: 
                case 32: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.readRowByte(imageInputStream, n3, rectangle, this.header.getOrigin(), n4, n5, byArray, writableRaster, raster, i);
                    break;
                }
                case 16: {
                    short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                    this.readRowUShort(imageInputStream, n3, rectangle, this.header.getOrigin(), n4, n5, sArray, writableRaster, raster, i);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported pixel depth: " + this.header.getPixelDepth()));
                }
            }
            this.processImageProgress(100.0f * (float)i / (float)n3);
            if (n3 - 1 - i < rectangle.y) break;
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
        this.processImageComplete();
        return bufferedImage;
    }

    private void readRowByte(DataInput dataInput, int n, Rectangle rectangle, int n2, int n3, int n4, byte[] byArray, WritableRaster writableRaster, Raster raster, int n5) throws IOException {
        int n6;
        if (n5 % n4 != 0 || n - 1 - n5 < rectangle.y || n - 1 - n5 >= rectangle.y + rectangle.height) {
            this.imageInput.skipBytes(byArray.length);
            return;
        }
        dataInput.readFully(byArray, 0, byArray.length);
        if (raster.getNumBands() == 4 && (this.header.getAttributeBits() == 0 || this.extensions != null && !this.extensions.hasAlpha())) {
            this.removeAlpha32(byArray);
        }
        if (n3 != 1) {
            for (n6 = 0; n6 < rectangle.width / n3; ++n6) {
                byArray[rectangle.x + n6] = byArray[rectangle.x + n6 * n3];
            }
        }
        switch (n2) {
            case 0: {
                n6 = (n - 1 - n5 - rectangle.y) / n4;
                writableRaster.setDataElements(0, n6, raster);
                break;
            }
            case 2: {
                writableRaster.setDataElements(0, n5, raster);
                break;
            }
            default: {
                throw new IIOException("Unsupported origin: " + n2);
            }
        }
    }

    private void removeAlpha32(byte[] byArray) {
        for (int i = 3; i < byArray.length; i += 4) {
            byArray[i] = -1;
        }
    }

    private void readRowUShort(DataInput dataInput, int n, Rectangle rectangle, int n2, int n3, int n4, short[] sArray, WritableRaster writableRaster, Raster raster, int n5) throws IOException {
        int n6;
        if (n5 % n4 != 0 || n - 1 - n5 < rectangle.y || n - 1 - n5 >= rectangle.y + rectangle.height) {
            dataInput.skipBytes(sArray.length * 2);
            return;
        }
        TGAImageReader.readFully(dataInput, sArray);
        if (n3 != 1) {
            for (n6 = 0; n6 < rectangle.width / n3; ++n6) {
                sArray[rectangle.x + n6] = sArray[rectangle.x + n6 * n3];
            }
        }
        switch (n2) {
            case 0: {
                n6 = (n - 1 - n5 - rectangle.y) / n4;
                writableRaster.setDataElements(0, n6, raster);
                break;
            }
            case 2: {
                writableRaster.setDataElements(0, n5, raster);
                break;
            }
            default: {
                throw new IIOException("Unsupported origin: " + n2);
            }
        }
    }

    private static void readFully(DataInput dataInput, short[] sArray) throws IOException {
        if (dataInput instanceof ImageInputStream) {
            ((ImageInputStream)dataInput).readFully(sArray, 0, sArray.length);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = dataInput.readShort();
            }
        }
    }

    private Raster clipRowToRect(Raster raster, Rectangle rectangle, int[] nArray, int n) {
        if (rectangle.contains(raster.getMinX(), 0, raster.getWidth(), 1) && n == 1 && nArray == null) {
            return raster;
        }
        return raster.createChild(rectangle.x / n, 0, rectangle.width / n, 1, 0, 0, nArray);
    }

    private WritableRaster clipToRect(WritableRaster writableRaster, Rectangle rectangle, int[] nArray) {
        if (rectangle.contains(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()) && nArray == null) {
            return writableRaster;
        }
        return writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, nArray);
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.imageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.header = TGAHeader.read(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
            TGAImageReader.skipToEnd(this.imageInput);
            this.imageInput.seek(this.imageInput.getStreamPosition() - 26L);
            long l = this.imageInput.readInt();
            this.imageInput.readInt();
            byte[] byArray = new byte[18];
            this.imageInput.readFully(byArray);
            if (Arrays.equals(byArray, TGA.MAGIC) && l > 0L) {
                this.imageInput.seek(l);
                this.extensions = TGAExtensions.read(this.imageInput);
            }
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    private static void skipToEnd(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream.length() > 0L) {
            imageInputStream.seek(imageInputStream.length());
        } else {
            long l = imageInputStream.getStreamPosition();
            while (imageInputStream.read() != -1) {
                l = imageInputStream.getStreamPosition();
                imageInputStream.skipBytes(1024);
            }
            imageInputStream.seek(l);
            while (imageInputStream.read() != -1) {
            }
        }
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public boolean hasThumbnails(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.extensions != null && this.extensions.getThumbnailOffset() > 0L;
    }

    public int getNumThumbnails(int n) throws IOException {
        return this.hasThumbnails(n) ? 1 : 0;
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        this.checkBounds(n);
        Validate.isTrue((n2 >= 0 && n2 < this.getNumThumbnails(n) ? 1 : 0) != 0, (String)"thumbnailIndex >= numThumbnails");
        this.imageInput.seek(this.extensions.getThumbnailOffset());
        return this.imageInput.readUnsignedByte();
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        this.getThumbnailWidth(n, n2);
        return this.imageInput.readUnsignedByte();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        Iterator<ImageTypeSpecifier> iterator = this.getImageTypes(n);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        int n3 = this.getThumbnailWidth(n, n2);
        int n4 = this.getThumbnailHeight(n, n2);
        Rectangle rectangle = new Rectangle(n3, n4);
        BufferedImage bufferedImage = TGAImageReader.getDestination(null, iterator, (int)n3, (int)n4);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = imageTypeSpecifier.createBufferedImage(n3, 1).getRaster();
        this.processThumbnailStarted(n, n2);
        this.imageInput.seek(this.extensions.getThumbnailOffset() + 2L);
        for (int i = 0; i < n4; ++i) {
            switch (this.header.getPixelDepth()) {
                case 8: 
                case 24: 
                case 32: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    this.readRowByte(this.imageInput, n4, rectangle, this.header.getOrigin(), 1, 1, byArray, writableRaster, writableRaster2, i);
                    break;
                }
                case 16: {
                    short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                    this.readRowUShort(this.imageInput, n4, rectangle, this.header.getOrigin(), 1, 1, sArray, writableRaster, writableRaster2, i);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported pixel depth: " + this.header.getPixelDepth()));
                }
            }
            this.processThumbnailProgress(100.0f * (float)i / (float)n4);
            if (n4 - 1 - i < rectangle.y) break;
        }
        this.processThumbnailComplete();
        return bufferedImage;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return new TGAMetadata(this.header, this.extensions);
    }

    public static void main(String[] stringArray) throws IOException {
        TGAImageReaderSpi tGAImageReaderSpi = new TGAImageReaderSpi();
        TGAImageReader tGAImageReader = new TGAImageReader((ImageReaderSpi)((Object)tGAImageReaderSpi));
        for (String string : stringArray) {
            File file = new File(string);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            System.err.println("Can read?: " + tGAImageReaderSpi.canDecodeInput(imageInputStream));
            tGAImageReader.setInput(imageInputStream);
            ImageReadParam imageReadParam = tGAImageReader.getDefaultReadParam();
            imageReadParam.setDestinationType(tGAImageReader.getImageTypes(0).next());
            BufferedImage bufferedImage = tGAImageReader.read(0, imageReadParam);
            System.err.println("image: " + bufferedImage);
            TGAImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
            System.err.println("reader.header: " + tGAImageReader.header);
            new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(tGAImageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0"), false);
        }
    }
}

