/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import com.twelvemonkeys.imageio.plugins.tga.TGAImageWriter;
import com.twelvemonkeys.imageio.plugins.tga.TGAProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageWriterSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.awt.color.ColorSpace;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public final class TGAImageWriterSpi
extends ImageWriterSpiBase {
    public TGAImageWriterSpi() {
        super((ReaderWriterProviderInfo)new TGAProviderInfo());
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        switch (imageTypeSpecifier.getBufferedImageType()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                return false;
            }
        }
        ColorSpace colorSpace = imageTypeSpecifier.getColorModel().getColorSpace();
        return colorSpace.getType() == 5 || colorSpace.getType() == 6;
    }

    public ImageWriter createWriterInstance(Object object) {
        return new TGAImageWriter((ImageWriterSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "TrueVision TGA image writer";
    }
}

