/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import com.twelvemonkeys.lang.Validate;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.WritableRaster;

public final class RasterUtils {
    private RasterUtils() {
    }

    public static WritableRaster asByteRaster(WritableRaster writableRaster, ColorModel colorModel) {
        switch (writableRaster.getTransferType()) {
            case 0: {
                return writableRaster;
            }
            case 3: {
                final int n = colorModel.getNumComponents();
                final DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                int n2 = writableRaster.getWidth();
                int n3 = writableRaster.getHeight();
                int n4 = dataBufferInt.getSize();
                return new WritableRaster(new PixelInterleavedSampleModel(0, n2, n3, n, n2 * n, RasterUtils.createBandOffsets(colorModel)), new DataBuffer(0, n4 * n){
                    final int[] MASKS;
                    {
                        super(n4, n2);
                        this.MASKS = new int[]{-256, -65281, -16711681, 0xFFFFFF};
                    }

                    @Override
                    public int getElem(int n5, int n2) {
                        int n3 = n2 / n;
                        int n4 = n2 % n * 8;
                        return dataBufferInt.getElem(n3) >>> n4 & 0xFF;
                    }

                    @Override
                    public void setElem(int n8, int n2, int n3) {
                        int n4 = n2 / n;
                        int n5 = n2 % n;
                        int n6 = n5 * 8;
                        int n7 = dataBufferInt.getElem(n4) & this.MASKS[n5] | (n3 & 0xFF) << n6;
                        dataBufferInt.setElem(n4, n7);
                    }
                }, new Point()){};
            }
        }
        throw new IllegalArgumentException(String.format("Raster type %d not supported", writableRaster.getTransferType()));
    }

    private static int[] createBandOffsets(ColorModel colorModel) {
        Validate.notNull((Object)colorModel, (String)"colorModel");
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int[] nArray = directColorModel.getMasks();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = 0;
                if (n != 0) {
                    while ((n & 0xFF) == 0) {
                        n >>>= 8;
                        ++n2;
                    }
                }
                nArray2[i] = n2;
            }
            return nArray2;
        }
        throw new IllegalArgumentException(String.format("%s not supported", colorModel.getClass().getSimpleName()));
    }
}

