/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.IndexImage;
import com.twelvemonkeys.image.InverseColorMap;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class InverseColorMapIndexColorModel
extends IndexColorModel {
    protected int[] mRGBs;
    protected int mMapSize;
    protected InverseColorMap mInverseMap = null;
    private static final int ALPHA_THRESHOLD = 128;
    private int mWhiteIndex = -1;
    private static final int WHITE = 0xFFFFFF;
    private static final int RGB_MASK = 0xFFFFFF;

    public InverseColorMapIndexColorModel(IndexColorModel pColorModel) {
        this(pColorModel, InverseColorMapIndexColorModel.getRGBs(pColorModel));
    }

    private InverseColorMapIndexColorModel(IndexColorModel pColorModel, int[] pRGBs) {
        super(pColorModel.getComponentSize()[0], pColorModel.getMapSize(), pRGBs, 0, ImageUtil.getTransferType(pColorModel), pColorModel.getValidPixels());
        this.mRGBs = pRGBs;
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    private static int[] getRGBs(IndexColorModel pColorModel) {
        int[] rgb = new int[pColorModel.getMapSize()];
        pColorModel.getRGBs(rgb);
        return rgb;
    }

    public InverseColorMapIndexColorModel(int pNumBits, int pSize, int[] pRGBs, int pStart, boolean pAlpha, int pTransparentIndex, int pTransferType) {
        super(pNumBits, pSize, pRGBs, pStart, pAlpha, pTransparentIndex, pTransferType);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs, pTransparentIndex);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int pNumBits, int pSize, byte[] pReds, byte[] pGreens, byte[] pBlues, int pTransparentIndex) {
        super(pNumBits, pSize, pReds, pGreens, pBlues, pTransparentIndex);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs, pTransparentIndex);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int pNumBits, int pSize, byte[] pReds, byte[] pGreens, byte[] pBlues) {
        super(pNumBits, pSize, pReds, pGreens, pBlues);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    private int getWhiteIndex() {
        for (int i = 0; i < this.mRGBs.length; ++i) {
            int color = this.mRGBs[i];
            if ((color & 0xFFFFFF) != 0xFFFFFF) continue;
            return i;
        }
        return -1;
    }

    public static IndexColorModel create(Image pImage, int pNumCols, int pFlags) {
        IndexColorModel icm = IndexImage.getIndexColorModel(pImage, pNumCols, pFlags);
        InverseColorMapIndexColorModel cm = icm instanceof InverseColorMapIndexColorModel ? (InverseColorMapIndexColorModel)icm : new InverseColorMapIndexColorModel(icm);
        return cm;
    }

    public Object getDataElements(int rgb, Object pixel) {
        int color;
        int alpha = rgb >>> 24;
        int pix = alpha < 128 && this.getTransparentPixel() != -1 ? this.getTransparentPixel() : ((color = rgb & 0xFFFFFF) == 0xFFFFFF && this.mWhiteIndex != -1 ? this.mWhiteIndex : this.mInverseMap.getIndexNearest(color));
        return this.installpixel(pixel, pix);
    }

    private Object installpixel(Object pixel, int pix) {
        switch (this.transferType) {
            case 3: {
                int[] intObj;
                if (pixel == null) {
                    intObj = new int[1];
                    pixel = intObj;
                } else {
                    intObj = (int[])pixel;
                }
                intObj[0] = pix;
                break;
            }
            case 0: {
                byte[] byteObj;
                if (pixel == null) {
                    byteObj = new byte[1];
                    pixel = byteObj;
                } else {
                    byteObj = (byte[])pixel;
                }
                byteObj[0] = (byte)pix;
                break;
            }
            case 1: {
                short[] shortObj;
                if (pixel == null) {
                    shortObj = new short[1];
                    pixel = shortObj;
                } else {
                    shortObj = (short[])pixel;
                }
                shortObj[0] = (short)pix;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return pixel;
    }

    public String toString() {
        return StringUtil.replace(super.toString(), "IndexColorModel: ", this.getClass().getName() + ": ");
    }
}

