/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.Magick;
import com.twelvemonkeys.image.MagickUtil;
import com.twelvemonkeys.image.ResampleOp;
import com.twelvemonkeys.lang.SystemUtil;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import magick.MagickImage;

final class MagickAccelerator {
    private static final boolean DEBUG = Magick.DEBUG;
    private static final boolean USE_MAGICK = MagickAccelerator.useMagick();
    private static final int RESAMPLE_OP = 0;
    private static Class[] sNativeOp = new Class[1];

    MagickAccelerator() {
    }

    private static boolean useMagick() {
        try {
            boolean useMagick;
            boolean available = SystemUtil.isClassAvailable("magick.MagickImage");
            if (DEBUG && !available) {
                System.err.print("ImageMagick bindings not available.");
            }
            boolean bl = useMagick = available && !"FALSE".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.image.accel"));
            if (DEBUG) {
                System.err.println(useMagick ? "Will use ImageMagick bindings to accelerate image resampling operations." : "Will not use ImageMagick to accelerate image resampling operations.");
            }
            return useMagick;
        }
        catch (Throwable t) {
            System.err.println("Could not enable ImageMagick bindings: " + t);
            return false;
        }
    }

    private static int getNativeOpIndex(Class pOpClass) {
        for (int i = 0; i < sNativeOp.length; ++i) {
            if (pOpClass != sNativeOp[i]) continue;
            return i;
        }
        return -1;
    }

    public static BufferedImage filter(BufferedImageOp pOperation, BufferedImage pInput, BufferedImage pOutput) {
        if (!USE_MAGICK) {
            return null;
        }
        BufferedImage result = null;
        switch (MagickAccelerator.getNativeOpIndex(pOperation.getClass())) {
            case 0: {
                ResampleOp resample = (ResampleOp)pOperation;
                result = MagickAccelerator.resampleMagick(pInput, resample.mWidth, resample.mHeight, resample.mFilterType);
                if (pOutput == null) break;
                ImageUtil.drawOnto(pOutput, result);
                result = pOutput;
                break;
            }
        }
        return result;
    }

    private static BufferedImage resampleMagick(BufferedImage pSrc, int pWidth, int pHeight, int pFilterType) {
        MagickImage image = null;
        MagickImage scaled = null;
        try {
            image = MagickUtil.toMagick(pSrc);
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
            }
            image.setFilter(pFilterType);
            scaled = image.zoomImage(pWidth, pHeight);
            if (DEBUG) {
                long time = System.currentTimeMillis() - start;
                System.out.println("Filtered: " + time + " ms");
            }
            BufferedImage bufferedImage = MagickUtil.toBuffered(scaled);
            return bufferedImage;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ImageConversionException(e.getMessage(), e);
        }
        finally {
            if (image != null) {
                image.destroyImages();
            }
            if (scaled != null) {
                scaled.destroyImages();
            }
        }
    }

    static {
        try {
            MagickAccelerator.sNativeOp[0] = Class.forName("com.twelvemonkeys.image.ResampleOp");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find class: " + e);
        }
    }
}

