/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.CopyDither;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.image.Magick;
import com.twelvemonkeys.image.MonochromeColorModel;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import magick.MagickException;
import magick.MagickImage;
import magick.PixelPacket;

public final class MagickUtil {
    private static final IndexColorModel CM_MONOCHROME = MonochromeColorModel.getInstance();
    private static final ColorModel CM_COLOR_ALPHA = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel CM_COLOR_OPAQUE = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
    private static final ColorModel CM_GRAY_ALPHA = new ComponentColorModel(ColorSpace.getInstance(1003), true, true, 3, 0);
    private static final ColorModel CM_GRAY_OPAQUE = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
    private static final int[] BAND_OFF_TRANS = new int[]{3, 2, 1, 0};
    private static final int[] BAND_OFF_OPAQUE = new int[]{2, 1, 0};
    private static final Point LOCATION_UPPER_LEFT = new Point(0, 0);
    private static final boolean DEBUG = Magick.DEBUG;

    private MagickUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage toBuffered(MagickImage pImage) throws MagickException {
        if (pImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        long start = 0L;
        if (DEBUG) {
            start = System.currentTimeMillis();
        }
        BufferedImage image = null;
        try {
            switch (pImage.getImageType()) {
                case 1: {
                    image = MagickUtil.bilevelToBuffered(pImage);
                    return image;
                }
                case 2: {
                    image = MagickUtil.grayToBuffered(pImage, false);
                    return image;
                }
                case 3: {
                    image = MagickUtil.grayToBuffered(pImage, true);
                    return image;
                }
                case 4: {
                    image = MagickUtil.paletteToBuffered(pImage, false);
                    return image;
                }
                case 5: {
                    image = MagickUtil.paletteToBuffered(pImage, true);
                    return image;
                }
                case 6: {
                    image = MagickUtil.rgbToBuffered(pImage, false);
                    return image;
                }
                case 7: {
                    image = MagickUtil.rgbToBuffered(pImage, true);
                    return image;
                }
                default: {
                    throw new IllegalArgumentException("Unknown JMagick image type: " + pImage.getImageType());
                }
            }
        }
        finally {
            if (DEBUG) {
                long time = System.currentTimeMillis() - start;
                System.out.println("Converted JMagick image type: " + pImage.getImageType() + " to BufferedImage: " + image);
                System.out.println("Conversion to BufferedImage: " + time + " ms");
            }
        }
    }

    public static MagickImage toMagick(BufferedImage pImage) throws MagickException {
        if (pImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        long start = 0L;
        if (DEBUG) {
            start = System.currentTimeMillis();
        }
        try {
            ColorModel cm = pImage.getColorModel();
            if (cm instanceof IndexColorModel) {
                MagickImage magickImage = MagickUtil.indexedToMagick(pImage, (IndexColorModel)cm, cm.hasAlpha());
                return magickImage;
            }
            switch (cm.getColorSpace().getType()) {
                case 6: {
                    MagickImage magickImage = MagickUtil.grayToMagick(pImage, cm.hasAlpha());
                    return magickImage;
                }
                case 5: {
                    MagickImage magickImage = MagickUtil.rgbToMagic(pImage, cm.hasAlpha());
                    return magickImage;
                }
            }
            throw new IllegalArgumentException("Unknown buffered image type: " + pImage);
        }
        finally {
            if (DEBUG) {
                long time = System.currentTimeMillis() - start;
                System.out.println("Conversion to MagickImage: " + time + " ms");
            }
        }
    }

    private static MagickImage rgbToMagic(BufferedImage pImage, boolean pAlpha) throws MagickException {
        MagickImage image = new MagickImage();
        BufferedImage buffered = ImageUtil.toBuffered(pImage, pAlpha ? 6 : 5);
        Raster raster = buffered.getRaster().getParent() != null ? buffered.getData(new Rectangle(buffered.getWidth(), buffered.getHeight())) : buffered.getRaster();
        image.constituteImage(buffered.getWidth(), buffered.getHeight(), pAlpha ? "ABGR" : "BGR", ((DataBufferByte)raster.getDataBuffer()).getData());
        return image;
    }

    private static MagickImage grayToMagick(BufferedImage pImage, boolean pAlpha) throws MagickException {
        MagickImage image = new MagickImage();
        BufferedImage buffered = ImageUtil.toBuffered(pImage, pAlpha ? 6 : 10);
        Raster raster = buffered.getRaster().getParent() != null ? buffered.getData(new Rectangle(buffered.getWidth(), buffered.getHeight())) : buffered.getRaster();
        image.constituteImage(buffered.getWidth(), buffered.getHeight(), pAlpha ? "ABGR" : "I", ((DataBufferByte)raster.getDataBuffer()).getData());
        return image;
    }

    private static MagickImage indexedToMagick(BufferedImage pImage, IndexColorModel pColorModel, boolean pAlpha) throws MagickException {
        MagickImage image = MagickUtil.rgbToMagic(pImage, pAlpha);
        int mapSize = pColorModel.getMapSize();
        image.setNumberColors(mapSize);
        return image;
    }

    private static BufferedImage bilevelToBuffered(MagickImage pImage) throws MagickException {
        BufferedImage temp = MagickUtil.grayToBuffered(pImage, false);
        BufferedImage image = new BufferedImage(temp.getWidth(), temp.getHeight(), 12, CM_MONOCHROME);
        ImageUtil.drawOnto(image, temp);
        return image;
    }

    private static BufferedImage grayToBuffered(MagickImage pImage, boolean pAlpha) throws MagickException {
        int[] nArray;
        Dimension size = pImage.getDimension();
        int length = size.width * size.height;
        int bands = pAlpha ? 2 : 1;
        byte[] pixels = new byte[length * bands];
        pImage.dispatchImage(0, 0, size.width, size.height, pAlpha ? "AI" : "I", pixels);
        DataBufferByte buffer = new DataBufferByte(pixels, pixels.length);
        if (pAlpha) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        int[] bandOffsets = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(buffer, size.width, size.height, size.width * bands, bands, bandOffsets, LOCATION_UPPER_LEFT);
        return new BufferedImage(pAlpha ? CM_GRAY_ALPHA : CM_GRAY_OPAQUE, raster, pAlpha, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage paletteToBuffered(MagickImage pImage, boolean pAlpha) throws MagickException {
        IndexColorModel cm;
        try {
            cm = MagickUtil.createIndexColorModel(pImage.getColormap(), pAlpha);
        }
        catch (MagickException e) {
            return MagickUtil.rgbToBuffered(pImage, pAlpha);
        }
        BufferedImage temp = MagickUtil.rgbToBuffered(pImage, pAlpha);
        BufferedImage image = cm.getMapSize() <= 16 ? new BufferedImage(temp.getWidth(), temp.getHeight(), 12, cm) : new BufferedImage(temp.getWidth(), temp.getHeight(), 13, cm);
        if (pAlpha) {
            Graphics2D g = image.createGraphics();
            try {
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, temp.getWidth(), temp.getHeight());
            }
            finally {
                g.dispose();
            }
        }
        CopyDither op = new CopyDither(cm);
        op.filter(temp, image);
        return image;
    }

    public static IndexColorModel createIndexColorModel(PixelPacket[] pColormap, boolean pAlpha) {
        int[] colors = new int[pColormap.length];
        int trans = pAlpha ? colors.length - 1 : -1;
        for (int i = pColormap.length - 1; i != 0; --i) {
            PixelPacket color = pColormap[i];
            colors[i] = pAlpha ? 255 - (color.getOpacity() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF : (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        }
        return new InverseColorMapIndexColorModel(8, colors.length, colors, 0, pAlpha, trans, 0);
    }

    private static BufferedImage rgbToBuffered(MagickImage pImage, boolean pAlpha) throws MagickException {
        Dimension size = pImage.getDimension();
        int length = size.width * size.height;
        int bands = pAlpha ? 4 : 3;
        byte[] pixels = new byte[length * bands];
        pImage.dispatchImage(0, 0, size.width, size.height, pAlpha ? "ABGR" : "BGR", pixels);
        DataBufferByte buffer = new DataBufferByte(pixels, pixels.length);
        int[] bandOffsets = pAlpha ? BAND_OFF_TRANS : BAND_OFF_OPAQUE;
        WritableRaster raster = Raster.createInterleavedRaster(buffer, size.width, size.height, size.width * bands, bands, bandOffsets, LOCATION_UPPER_LEFT);
        return new BufferedImage(pAlpha ? CM_COLOR_ALPHA : CM_COLOR_OPAQUE, raster, pAlpha, null);
    }
}

