/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FastByteArrayOutputStream
extends ByteArrayOutputStream {
    protected int mMaxGrowSize = 0x100000;

    public FastByteArrayOutputStream(int pSize) {
        super(pSize);
    }

    public FastByteArrayOutputStream(byte[] pBuffer) {
        super(0);
        this.buf = pBuffer;
        this.count = pBuffer.length;
    }

    public synchronized void write(byte[] pBytes, int pOffset, int pLength) {
        if (pOffset < 0 || pOffset > pBytes.length || pLength < 0 || pOffset + pLength > pBytes.length || pOffset + pLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pLength == 0) {
            return;
        }
        int newcount = this.count + pLength;
        this.growIfNeeded(newcount);
        System.arraycopy(pBytes, pOffset, this.buf, this.count, pLength);
        this.count = newcount;
    }

    public synchronized void write(int pByte) {
        int newcount = this.count + 1;
        this.growIfNeeded(newcount);
        this.buf[this.count] = (byte)pByte;
        this.count = newcount;
    }

    private void growIfNeeded(int pNewcount) {
        if (pNewcount > this.buf.length) {
            int newSize = Math.max(Math.min(this.buf.length << 1, this.buf.length + this.mMaxGrowSize), pNewcount);
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
    }

    public void writeTo(OutputStream pOut) throws IOException {
        pOut.write(this.buf, 0, this.count);
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public ByteArrayInputStream createInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

