/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.UnixFileSystem;
import com.twelvemonkeys.io.Win32FileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

abstract class FileSystem {
    FileSystem() {
    }

    abstract long getFreeSpace(File var1);

    abstract long getTotalSpace(File var1);

    abstract String getName();

    static BufferedReader exec(String[] pArgs) throws IOException {
        Process cmd = Runtime.getRuntime().exec(pArgs);
        return new BufferedReader(new InputStreamReader(cmd.getInputStream()));
    }

    static FileSystem get() {
        String os = System.getProperty("os.name");
        if ((os = os.toLowerCase()).indexOf("windows") != -1) {
            return new Win32FileSystem();
        }
        if (os.indexOf("linux") != -1 || os.indexOf("sun os") != -1 || os.indexOf("sunos") != -1 || os.indexOf("solaris") != -1 || os.indexOf("mpe/ix") != -1 || os.indexOf("hp-ux") != -1 || os.indexOf("aix") != -1 || os.indexOf("freebsd") != -1 || os.indexOf("irix") != -1 || os.indexOf("digital unix") != -1 || os.indexOf("unix") != -1 || os.indexOf("mac os x") != -1) {
            return new UnixFileSystem();
        }
        return new UnknownFileSystem(os);
    }

    private static class UnknownFileSystem
    extends FileSystem {
        private final String mOSName;

        UnknownFileSystem(String pOSName) {
            this.mOSName = pOSName;
        }

        long getFreeSpace(File pPath) {
            return 0L;
        }

        long getTotalSpace(File pPath) {
            return 0L;
        }

        String getName() {
            return "Unknown (" + this.mOSName + ")";
        }
    }
}

