/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;

public class LittleEndianRandomAccessFile
implements DataInput,
DataOutput {
    private RandomAccessFile mFile;

    public LittleEndianRandomAccessFile(String pName, String pMode) throws FileNotFoundException {
        this(FileUtil.resolve(pName), pMode);
    }

    public LittleEndianRandomAccessFile(File pFile, String pMode) throws FileNotFoundException {
        this.mFile = new RandomAccessFile(pFile, pMode);
    }

    public void close() throws IOException {
        this.mFile.close();
    }

    public FileChannel getChannel() {
        return this.mFile.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.mFile.getFD();
    }

    public long getFilePointer() throws IOException {
        return this.mFile.getFilePointer();
    }

    public long length() throws IOException {
        return this.mFile.length();
    }

    public int read() throws IOException {
        return this.mFile.read();
    }

    public int read(byte[] b) throws IOException {
        return this.mFile.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.mFile.read(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.mFile.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.mFile.readFully(b, off, len);
    }

    public String readLine() throws IOException {
        return this.mFile.readLine();
    }

    public boolean readBoolean() throws IOException {
        int b = this.mFile.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    public byte readByte() throws IOException {
        int b = this.mFile.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public int readUnsignedByte() throws IOException {
        int b = this.mFile.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public short readShort() throws IOException {
        int byte1 = this.mFile.read();
        int byte2 = this.mFile.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24) >>> 24);
    }

    public int readUnsignedShort() throws IOException {
        int byte1 = this.mFile.read();
        int byte2 = this.mFile.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (byte2 << 8) + byte1;
    }

    public char readChar() throws IOException {
        int byte1 = this.mFile.read();
        int byte2 = this.mFile.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (char)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readInt() throws IOException {
        int byte1 = this.mFile.read();
        int byte2 = this.mFile.read();
        int byte3 = this.mFile.read();
        int byte4 = this.mFile.read();
        if (byte4 < 0) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 24 >>> 8) + (byte2 << 24 >>> 16) + (byte1 << 24 >>> 24);
    }

    public long readLong() throws IOException {
        long byte1 = this.mFile.read();
        long byte2 = this.mFile.read();
        long byte3 = this.mFile.read();
        long byte4 = this.mFile.read();
        long byte5 = this.mFile.read();
        long byte6 = this.mFile.read();
        long byte7 = this.mFile.read();
        long byte8 = this.mFile.read();
        if (byte8 < 0L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 56 >>> 8) + (byte6 << 56 >>> 16) + (byte5 << 56 >>> 24) + (byte4 << 56 >>> 32) + (byte3 << 56 >>> 40) + (byte2 << 56 >>> 48) + (byte1 << 56 >>> 56);
    }

    public String readUTF() throws IOException {
        int byte1 = this.mFile.read();
        int byte2 = this.mFile.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        int numbytes = (byte1 << 8) + byte2;
        char[] result = new char[numbytes];
        int numread = 0;
        int numchars = 0;
        while (numread < numbytes) {
            int c2;
            int c1 = this.readUnsignedByte();
            int test = c1 >> 4;
            if (test < 8) {
                ++numread;
                result[numchars++] = (char)c1;
                continue;
            }
            if (test == 12 || test == 13) {
                if ((numread += 2) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                continue;
            }
            if (test == 14) {
                if ((numread += 3) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                int c3 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(result, 0, numchars);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void seek(long pos) throws IOException {
        this.mFile.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        this.mFile.setLength(newLength);
    }

    public int skipBytes(int n) throws IOException {
        return this.mFile.skipBytes(n);
    }

    public void write(byte[] b) throws IOException {
        this.mFile.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.mFile.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.mFile.write(b);
    }

    public void writeBoolean(boolean pBoolean) throws IOException {
        if (pBoolean) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int pByte) throws IOException {
        this.mFile.write(pByte);
    }

    public void writeShort(int pShort) throws IOException {
        this.mFile.write(pShort & 0xFF);
        this.mFile.write(pShort >>> 8 & 0xFF);
    }

    public void writeChar(int pChar) throws IOException {
        this.mFile.write(pChar & 0xFF);
        this.mFile.write(pChar >>> 8 & 0xFF);
    }

    public void writeInt(int pInt) throws IOException {
        this.mFile.write(pInt & 0xFF);
        this.mFile.write(pInt >>> 8 & 0xFF);
        this.mFile.write(pInt >>> 16 & 0xFF);
        this.mFile.write(pInt >>> 24 & 0xFF);
    }

    public void writeLong(long pLong) throws IOException {
        this.mFile.write((int)pLong & 0xFF);
        this.mFile.write((int)(pLong >>> 8) & 0xFF);
        this.mFile.write((int)(pLong >>> 16) & 0xFF);
        this.mFile.write((int)(pLong >>> 24) & 0xFF);
        this.mFile.write((int)(pLong >>> 32) & 0xFF);
        this.mFile.write((int)(pLong >>> 40) & 0xFF);
        this.mFile.write((int)(pLong >>> 48) & 0xFF);
        this.mFile.write((int)(pLong >>> 56) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            this.mFile.write((byte)pString.charAt(i));
        }
    }

    public void writeChars(String pString) throws IOException {
        int length = pString.length();
        for (int i = 0; i < length; ++i) {
            char c = pString.charAt(i);
            this.mFile.write(c & 0xFF);
            this.mFile.write(c >>> 8 & 0xFF);
        }
    }

    public void writeUTF(String pString) throws IOException {
        char c;
        int i;
        int numchars = pString.length();
        int numbytes = 0;
        for (i = 0; i < numchars; ++i) {
            c = pString.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++numbytes;
                continue;
            }
            if (c > '\u07ff') {
                numbytes += 3;
                continue;
            }
            numbytes += 2;
        }
        if (numbytes > 65535) {
            throw new UTFDataFormatException();
        }
        this.mFile.write(numbytes >>> 8 & 0xFF);
        this.mFile.write(numbytes & 0xFF);
        for (i = 0; i < numchars; ++i) {
            c = pString.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.mFile.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.mFile.write(0xE0 | c >> 12 & 0xF);
                this.mFile.write(0x80 | c >> 6 & 0x3F);
                this.mFile.write(0x80 | c & 0x3F);
                continue;
            }
            this.mFile.write(0xC0 | c >> 6 & 0x1F);
            this.mFile.write(0x80 | c & 0x3F);
        }
    }
}

