/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DecoderStream
extends FilterInputStream {
    protected int mBufferPos;
    protected int mBufferLimit;
    protected final byte[] mBuffer;
    protected final Decoder mDecoder;

    public DecoderStream(InputStream pStream, Decoder pDecoder) {
        super(pStream);
        this.mDecoder = pDecoder;
        this.mBuffer = new byte[1024];
        this.mBufferPos = 0;
        this.mBufferLimit = 0;
    }

    public int available() throws IOException {
        return this.mBufferLimit - this.mBufferPos + super.available();
    }

    public int read() throws IOException {
        if (this.mBufferPos == this.mBufferLimit) {
            this.mBufferLimit = this.fill();
        }
        if (this.mBufferLimit < 0) {
            return -1;
        }
        return this.mBuffer[this.mBufferPos++] & 0xFF;
    }

    public int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes.length);
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        int count;
        int dstLen;
        if (pBytes == null) {
            throw new NullPointerException();
        }
        if (pOffset < 0 || pOffset > pBytes.length || pLength < 0 || pOffset + pLength > pBytes.length || pOffset + pLength < 0) {
            throw new IndexOutOfBoundsException("bytes.length=" + pBytes.length + " offset=" + pOffset + " length=" + pLength);
        }
        if (pLength == 0) {
            return 0;
        }
        if (this.mBufferLimit - this.mBufferPos < 0) {
            return -1;
        }
        int off = pOffset;
        for (count = 0; pLength > count; count += dstLen) {
            int avail = this.mBufferLimit - this.mBufferPos;
            if (avail <= 0) {
                this.mBufferLimit = this.fill();
                if (this.mBufferLimit < 0) break;
            }
            dstLen = Math.min(pLength - count, avail);
            System.arraycopy(this.mBuffer, this.mBufferPos, pBytes, off, dstLen);
            this.mBufferPos += dstLen;
            off += dstLen;
        }
        return count;
    }

    public long skip(long pLength) throws IOException {
        long total;
        int skipped;
        if (this.mBufferLimit - this.mBufferPos < 0) {
            return 0L;
        }
        for (total = 0L; total < pLength; total += (long)skipped) {
            int avail = this.mBufferLimit - this.mBufferPos;
            if (avail == 0) {
                this.mBufferLimit = this.fill();
                if (this.mBufferLimit < 0) break;
            }
            skipped = (int)Math.min(pLength - total, (long)avail);
            this.mBufferPos += skipped;
        }
        return total;
    }

    protected int fill() throws IOException {
        int read = this.mDecoder.decode(this.in, this.mBuffer);
        if (read > this.mBuffer.length) {
            throw new AssertionError((Object)String.format("Decode beyond buffer (%d): %d (using %s decoder)", this.mBuffer.length, read, this.mDecoder.getClass().getName()));
        }
        this.mBufferPos = 0;
        if (read == 0) {
            return -1;
        }
        return read;
    }
}

