/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Entry
implements Comparable<Entry> {
    String name;
    byte type;
    byte nodeColor;
    int prevDId;
    int nextDId;
    int rootNodeDId;
    long createdTimestamp;
    long modifiedTimestamp;
    int startSId;
    int streamSize;
    CompoundDocument mDocument;
    Entry mParent;
    SortedSet<Entry> mChildren;
    public static final int LENGTH = 128;
    static final int EMPTY = 0;
    static final int USER_STORAGE = 1;
    static final int USER_STREAM = 2;
    static final int LOCK_BYTES = 3;
    static final int PROPERTY = 4;
    static final int ROOT_STORAGE = 5;
    private static final SortedSet<Entry> NO_CHILDREN = Collections.unmodifiableSortedSet(new TreeSet());

    private Entry() {
    }

    static Entry readEntry(DataInput pInput) throws IOException {
        Entry p = new Entry();
        p.read(pInput);
        return p;
    }

    private void read(DataInput pInput) throws IOException {
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = pInput.readChar();
        }
        short nameLength = pInput.readShort();
        this.name = new String(chars, 0, (nameLength - 1) / 2);
        this.type = pInput.readByte();
        this.nodeColor = pInput.readByte();
        this.prevDId = pInput.readInt();
        this.nextDId = pInput.readInt();
        this.rootNodeDId = pInput.readInt();
        if (pInput.skipBytes(20) != 20) {
            throw new CorruptDocumentException();
        }
        this.createdTimestamp = CompoundDocument.toJavaTimeInMillis(pInput.readLong());
        this.modifiedTimestamp = CompoundDocument.toJavaTimeInMillis(pInput.readLong());
        this.startSId = pInput.readInt();
        this.streamSize = pInput.readInt();
        pInput.readInt();
    }

    public boolean isRoot() {
        return this.type == 5;
    }

    public boolean isDirectory() {
        return this.type == 1;
    }

    public boolean isFile() {
        return this.type == 2;
    }

    public String getName() {
        return this.name;
    }

    public SeekableInputStream getInputStream() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        return this.mDocument.getInputStreamForSId(this.startSId, this.streamSize);
    }

    public long length() {
        if (this.isDirectory()) {
            return 0L;
        }
        return this.streamSize;
    }

    public long created() {
        return this.createdTimestamp;
    }

    public long lastModified() {
        return this.modifiedTimestamp;
    }

    public Entry getParentEntry() {
        return this.mParent;
    }

    public Entry getChildEntry(String pName) throws IOException {
        if (this.isFile() || this.rootNodeDId == -1) {
            return null;
        }
        Entry dummy = new Entry();
        dummy.name = pName;
        dummy.mParent = this;
        SortedSet<Entry> child = this.getChildEntries().tailSet(dummy);
        return child.first();
    }

    public SortedSet<Entry> getChildEntries() throws IOException {
        if (this.mChildren == null) {
            this.mChildren = this.isFile() || this.rootNodeDId == -1 ? NO_CHILDREN : this.mDocument.getEntries(this.rootNodeDId, this);
        }
        return this.mChildren;
    }

    public String toString() {
        return "\"" + this.name + "\"" + " (" + (this.isFile() ? "Document" : (this.isDirectory() ? "Directory" : "Root")) + (this.mParent != null ? ", parent: \"" + this.mParent.getName() + "\"" : "") + (this.isFile() ? "" : ", children: " + (this.mChildren != null ? String.valueOf(this.mChildren.size()) : "(unknown)")) + ", SId=" + this.startSId + ", length=" + this.streamSize + ")";
    }

    public boolean equals(Object pOther) {
        if (pOther == this) {
            return true;
        }
        if (!(pOther instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)pOther;
        return this.name.equals(other.name) && (this.mParent == other.mParent || this.mParent != null && this.mParent.equals(other.mParent));
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.startSId;
    }

    @Override
    public int compareTo(Entry pOther) {
        if (this == pOther) {
            return 0;
        }
        int diff = this.name.length() - pOther.name.length();
        if (diff != 0) {
            return diff;
        }
        return this.name.compareTo(pOther.name);
    }
}

