/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.xml;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.xml.DOMSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSerializer {
    private final OutputStream mOutput;
    private final Charset mEncoding;
    private final SerializationContext mContext;

    public XMLSerializer(OutputStream pOutput, String pEncoding) {
        this.mOutput = pOutput;
        this.mEncoding = Charset.forName(pEncoding);
        this.mContext = new SerializationContext();
    }

    public void setIndentation(String pIndent) {
        this.mContext.indent = pIndent != null ? pIndent : "  ";
    }

    public void setStripComments(boolean pStrip) {
        this.mContext.stripComments = pStrip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Document pDocument) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.mOutput, this.mEncoding));
        try {
            this.writeXMLDeclararion(out);
            this.writeXML(out, pDocument, this.mContext.copy());
        }
        finally {
            out.flush();
        }
    }

    private void writeXMLDeclararion(PrintWriter pOut) {
        pOut.print("<?xml version=\"1.0\" encoding=\"");
        pOut.print(this.mEncoding.name());
        pOut.println("\"?>");
    }

    private void writeXML(PrintWriter pOut, Document pDocument, SerializationContext pContext) {
        this.writeNodeRecursive(pOut, pDocument, pContext);
    }

    private void writeNodeRecursive(PrintWriter pOut, Node pNode, SerializationContext pContext) {
        if (pNode.getNodeType() != 3) {
            XMLSerializer.indentToLevel(pOut, pContext);
        }
        switch (pNode.getNodeType()) {
            case 9: 
            case 11: {
                this.writeDocument(pOut, pNode, pContext);
                break;
            }
            case 10: {
                this.writeDoctype(pOut, (DocumentType)pNode);
                break;
            }
            case 1: {
                boolean preserveSpace = pContext.preserveSpace;
                XMLSerializer.updatePreserveSpace(pNode, pContext);
                this.writeElement(pOut, (Element)pNode, pContext);
                pContext.preserveSpace = preserveSpace;
                break;
            }
            case 4: {
                this.writeCData(pOut, pNode);
                break;
            }
            case 3: {
                this.writeText(pOut, pNode, pContext);
                break;
            }
            case 8: {
                this.writeComment(pOut, pNode, pContext);
                break;
            }
            case 7: {
                this.writeProcessingInstruction(pOut, pNode);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Malformed input Document: Attribute nodes should only occur inside Element nodes");
            }
            default: {
                throw new InternalError("Lazy programmer never implemented serialization of " + pNode.getClass());
            }
        }
    }

    private void writeProcessingInstruction(PrintWriter pOut, Node pNode) {
        pOut.print("\n<?");
        pOut.print(pNode.getNodeValue());
        pOut.println("?>");
    }

    private void writeText(PrintWriter pOut, Node pNode, SerializationContext pContext) {
        String value = pNode.getNodeValue();
        if (pContext.preserveSpace) {
            pOut.print(XMLSerializer.maybeEscapeElementValue(value));
        } else if (!StringUtil.isEmpty(value)) {
            XMLSerializer.indentToLevel(pOut, pContext);
            pOut.println(XMLSerializer.maybeEscapeElementValue(value.trim()));
        }
    }

    private void writeCData(PrintWriter pOut, Node pNode) {
        pOut.print("<![CDATA[");
        pOut.print(XMLSerializer.validateCDataValue(pNode.getNodeValue()));
        pOut.println("]]>");
    }

    private static void updatePreserveSpace(Node pNode, SerializationContext pContext) {
        Node space;
        NamedNodeMap attributes = pNode.getAttributes();
        if (attributes != null && (space = attributes.getNamedItem("xml:space")) != null) {
            if ("preserve".equals(space.getNodeValue())) {
                pContext.preserveSpace = true;
            } else if ("default".equals(space.getNodeValue())) {
                pContext.preserveSpace = false;
            }
        }
    }

    private static void indentToLevel(PrintWriter pOut, SerializationContext pContext) {
        for (int i = 0; i < pContext.level; ++i) {
            pOut.print(pContext.indent);
        }
    }

    private void writeComment(PrintWriter pOut, Node pNode, SerializationContext pContext) {
        if (pContext.stripComments) {
            return;
        }
        String value = pNode.getNodeValue();
        XMLSerializer.validateCommenValue(value);
        if (value.startsWith(" ")) {
            pOut.print("<!--");
        } else {
            pOut.print("<!-- ");
        }
        pOut.print(value);
        if (value.endsWith(" ")) {
            pOut.println("-->");
        } else {
            pOut.println(" -->");
        }
    }

    static String maybeEscapeElementValue(String pValue) {
        int pos;
        int startEscape = XMLSerializer.needsEscapeElement(pValue);
        if (startEscape < 0) {
            return pValue;
        }
        StringBuilder builder = new StringBuilder(pValue.substring(0, startEscape));
        builder.ensureCapacity(pValue.length() + 30);
        block5: for (int i = pos = startEscape; i < pValue.length(); ++i) {
            switch (pValue.charAt(i)) {
                case '&': {
                    pos = XMLSerializer.appendAndEscape(pValue, pos, i, builder, "&amp;");
                    continue block5;
                }
                case '<': {
                    pos = XMLSerializer.appendAndEscape(pValue, pos, i, builder, "&lt;");
                    continue block5;
                }
                case '>': {
                    pos = XMLSerializer.appendAndEscape(pValue, pos, i, builder, "&gt;");
                    continue block5;
                }
            }
        }
        builder.append(pValue.substring(pos));
        return builder.toString();
    }

    private static int appendAndEscape(String pString, int pStart, int pEnd, StringBuilder pBuilder, String pEntity) {
        pBuilder.append(pString.substring(pStart, pEnd));
        pBuilder.append(pEntity);
        return pEnd + 1;
    }

    private static int needsEscapeElement(String pString) {
        for (int i = 0; i < pString.length(); ++i) {
            switch (pString.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static String maybeEscapeAttributeValue(String pValue) {
        int pos;
        int startEscape = XMLSerializer.needsEscapeAttribute(pValue);
        if (startEscape < 0) {
            return pValue;
        }
        StringBuilder builder = new StringBuilder(pValue.substring(0, startEscape));
        builder.ensureCapacity(pValue.length() + 16);
        block4: for (int i = pos = startEscape; i < pValue.length(); ++i) {
            switch (pValue.charAt(i)) {
                case '&': {
                    pos = XMLSerializer.appendAndEscape(pValue, pos, i, builder, "&amp;");
                    continue block4;
                }
                case '\"': {
                    pos = XMLSerializer.appendAndEscape(pValue, pos, i, builder, "&quot;");
                    continue block4;
                }
            }
        }
        builder.append(pValue.substring(pos));
        return builder.toString();
    }

    private static int needsEscapeAttribute(String pString) {
        for (int i = 0; i < pString.length(); ++i) {
            switch (pString.charAt(i)) {
                case '\"': 
                case '&': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static String validateCDataValue(String pValue) {
        if (pValue.indexOf("]]>") >= 0) {
            throw new IllegalArgumentException("Malformed input document: CDATA block may not contain the string ']]>'");
        }
        return pValue;
    }

    private static String validateCommenValue(String pValue) {
        if (pValue.indexOf("--") >= 0) {
            throw new IllegalArgumentException("Malformed input document: Comment may not contain the string '--'");
        }
        return pValue;
    }

    private void writeDocument(PrintWriter pOut, Node pNode, SerializationContext pContext) {
        if (pNode.hasChildNodes()) {
            NodeList nodes = pNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.writeNodeRecursive(pOut, nodes.item(i), pContext);
            }
        }
    }

    private void writeElement(PrintWriter pOut, Element pNode, SerializationContext pContext) {
        int i;
        pOut.print("<");
        pOut.print(pNode.getTagName());
        String namespace = pNode.getNamespaceURI();
        if (namespace != null && !namespace.equals(pContext.defaultNamespace)) {
            String prefix = pNode.getPrefix();
            if (prefix == null) {
                pContext.defaultNamespace = namespace;
                pOut.print(" xmlns");
            } else {
                pOut.print(" xmlns:");
                pOut.print(prefix);
            }
            pOut.print("=\"");
            pOut.print(namespace);
            pOut.print("\"");
        }
        if (pNode.hasAttributes()) {
            NamedNodeMap attributes = pNode.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getName();
                if (name.startsWith("xmlns") && (name.length() == 5 || name.charAt(5) == ':')) continue;
                pOut.print(" ");
                pOut.print(name);
                pOut.print("=\"");
                pOut.print(XMLSerializer.maybeEscapeAttributeValue(attribute.getValue()));
                pOut.print("\"");
            }
        }
        if (pNode.hasChildNodes()) {
            pOut.print(">");
            if (!pContext.preserveSpace) {
                pOut.println();
            }
            NodeList children = pNode.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                this.writeNodeRecursive(pOut, children.item(i), pContext.push());
            }
            if (!pContext.preserveSpace) {
                XMLSerializer.indentToLevel(pOut, pContext);
            }
            pOut.print("</");
            pOut.print(pNode.getTagName());
            pOut.println(">");
        } else {
            pOut.println("/>");
        }
    }

    private void writeDoctype(PrintWriter pOut, DocumentType pDoctype) {
        if (pDoctype != null) {
            String internalSubset;
            String systemId;
            pOut.print("<!DOCTYPE ");
            pOut.print(pDoctype.getName());
            String publicId = pDoctype.getPublicId();
            if (!StringUtil.isEmpty(publicId)) {
                pOut.print(" PUBLIC ");
                pOut.print(publicId);
            }
            if (!StringUtil.isEmpty(systemId = pDoctype.getSystemId())) {
                if (StringUtil.isEmpty(publicId)) {
                    pOut.print(" SYSTEM \"");
                } else {
                    pOut.print(" \"");
                }
                pOut.print(systemId);
                pOut.print("\"");
            }
            if (!StringUtil.isEmpty(internalSubset = pDoctype.getInternalSubset())) {
                pOut.print(" [ ");
                pOut.print(internalSubset);
                pOut.print(" ]");
            }
            pOut.println(">");
        }
    }

    public static void main(String[] pArgs) throws IOException, SAXException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        DOMImplementation dom = builder.getDOMImplementation();
        Document document = dom.createDocument("http://www.twelvemonkeys.com/xml/test", "test", dom.createDocumentType("test", null, null));
        Element root = document.getDocumentElement();
        document.insertBefore(document.createComment(new Date().toString()), root);
        Element test = document.createElement("sub");
        root.appendChild(test);
        Element more = document.createElementNS("http://more.com/1999/namespace", "more:more");
        more.setAttribute("foo", "test");
        more.setAttribute("bar", "'really' \"legal\" & ok");
        test.appendChild(more);
        more.appendChild(document.createTextNode("Simply some text."));
        more.appendChild(document.createCDATASection("&something escaped;"));
        more.appendChild(document.createTextNode("More & <more>!"));
        more.appendChild(document.createTextNode("\"<<'&'>>\""));
        Element another = document.createElement("another");
        test.appendChild(another);
        Element yet = document.createElement("yet-another");
        yet.setAttribute("this-one", "with-params");
        test.appendChild(yet);
        Element pre = document.createElementNS("http://www.twelvemonkeys.com/xml/test", "pre");
        pre.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        pre.appendChild(document.createTextNode(" \t \n\r some text & white ' '   \n   "));
        test.appendChild(pre);
        System.out.println("XMLSerializer:");
        XMLSerializer serializer = new XMLSerializer(System.out, "UTF-8");
        serializer.serialize(document);
        System.out.println();
        System.out.println("DOMSerializer:");
        DOMSerializer serializerD = new DOMSerializer(System.out, "UTF-8");
        serializerD.setPrettyPrint(true);
        serializerD.serialize(document);
        System.out.println();
        System.out.println("\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer2 = new XMLSerializer(out, "UTF-8");
        serializer2.serialize(document);
        ByteArrayOutputStream outD = new ByteArrayOutputStream();
        DOMSerializer serializer2D = new DOMSerializer(outD, "UTF-8");
        serializer2D.serialize(document);
        Document document2 = builder.parse(new ByteArrayInputStream(out.toByteArray()));
        System.out.println("XMLSerializer reparsed XMLSerializer:");
        serializer.serialize(document2);
        System.out.println();
        System.out.println("DOMSerializer reparsed XMLSerializer:");
        serializerD.serialize(document2);
        System.out.println();
        Document documentD = builder.parse(new ByteArrayInputStream(outD.toByteArray()));
        System.out.println("XMLSerializer reparsed DOMSerializer:");
        serializer.serialize(documentD);
        System.out.println();
        System.out.println("DOMSerializer reparsed DOMSerializer:");
        serializerD.serialize(documentD);
        System.out.println();
    }

    static class SerializationContext
    implements Cloneable {
        String indent = "  ";
        int level = 0;
        boolean preserveSpace = false;
        boolean stripComments = false;
        String defaultNamespace;

        SerializationContext() {
        }

        public SerializationContext copy() {
            try {
                return (SerializationContext)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        public SerializationContext push() {
            SerializationContext context = this.copy();
            ++context.level;
            return context;
        }
    }
}

