/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.SubsamplingFilter;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;

public final class BufferedImageFactory {
    private List<ProgressListener> mListeners;
    private int mPercentageDone;
    private ImageProducer mProducer;
    private boolean mError;
    private boolean mFetching;
    private boolean mReadColorModelOnly;
    private int mX = 0;
    private int mY = 0;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mXSub = 1;
    private int mYSub = 1;
    private int mOffset;
    private int mScanSize;
    private ColorModel mSourceColorModel;
    private Hashtable mSourceProperties;
    private Object mSourcePixels;
    private BufferedImage mBuffered;
    private ColorModel mColorModel;
    private final Consumer mConsumer = new Consumer();

    public BufferedImageFactory(Image pSource) {
        this(pSource.getSource());
    }

    public BufferedImageFactory(ImageProducer pSource) {
        this.mProducer = pSource;
    }

    public BufferedImage getBufferedImage() throws ImageConversionException {
        this.doFetch(false);
        return this.mBuffered;
    }

    public ColorModel getColorModel() throws ImageConversionException {
        this.doFetch(true);
        return this.mBuffered != null ? this.mBuffered.getColorModel() : this.mColorModel;
    }

    public void dispose() {
        this.freeResources();
        this.mBuffered = null;
        this.mColorModel = null;
    }

    public void abort() {
        this.mConsumer.imageComplete(4);
    }

    public void setSourceRegion(Rectangle pRect) {
        if (this.mX != pRect.x || this.mY != pRect.y || this.mWidth != pRect.width || this.mHeight != pRect.height) {
            this.dispose();
        }
        this.mX = pRect.x;
        this.mY = pRect.y;
        this.mWidth = pRect.width;
        this.mHeight = pRect.height;
    }

    public void setSourceSubsampling(int pXSub, int pYSub) {
        if (this.mXSub != pXSub || this.mYSub != pYSub) {
            this.dispose();
        }
        if (pXSub > 1) {
            this.mXSub = pXSub;
        }
        if (pYSub > 1) {
            this.mYSub = pYSub;
        }
    }

    private synchronized void doFetch(boolean pColorModelOnly) throws ImageConversionException {
        if (!this.mFetching && (!pColorModelOnly && this.mBuffered == null || this.mBuffered == null && this.mSourceColorModel == null)) {
            if (!(pColorModelOnly || this.mXSub <= 1 && this.mYSub <= 1)) {
                if (this.mWidth > 0 && this.mHeight > 0) {
                    this.mWidth = (this.mWidth + this.mXSub - 1) / this.mXSub;
                    this.mHeight = (this.mHeight + this.mYSub - 1) / this.mYSub;
                    this.mX = (this.mX + this.mXSub - 1) / this.mXSub;
                    this.mY = (this.mY + this.mYSub - 1) / this.mYSub;
                }
                this.mProducer = new FilteredImageSource(this.mProducer, new SubsamplingFilter(this.mXSub, this.mYSub));
            }
            this.mFetching = true;
            this.mReadColorModelOnly = pColorModelOnly;
            this.mProducer.startProduction(this.mConsumer);
            while (this.mFetching) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ImageConversionException("Image conversion aborted: " + e.getMessage(), e);
                }
            }
            if (this.mError) {
                throw new ImageConversionException("Image conversion failed: ImageConsumer.IMAGEERROR.");
            }
            if (pColorModelOnly) {
                this.createColorModel();
            } else {
                this.createBuffered();
            }
        }
    }

    private void createColorModel() {
        this.mColorModel = this.mSourceColorModel;
        this.freeResources();
    }

    private void createBuffered() {
        if (this.mWidth > 0 && this.mHeight > 0) {
            if (this.mSourceColorModel != null && this.mSourcePixels != null) {
                WritableRaster raster = ImageUtil.createRaster(this.mWidth, this.mHeight, this.mSourcePixels, this.mSourceColorModel);
                this.mBuffered = new BufferedImage(this.mSourceColorModel, raster, this.mSourceColorModel.isAlphaPremultiplied(), this.mSourceProperties);
            } else {
                this.mBuffered = ImageUtil.createClear(this.mWidth, this.mHeight, null);
            }
        }
        this.freeResources();
    }

    private void freeResources() {
        this.mSourceColorModel = null;
        this.mSourcePixels = null;
        this.mSourceProperties = null;
    }

    private void processProgress(int mScanline) {
        int percent;
        if (this.mListeners != null && (percent = 100 * mScanline / this.mHeight) > this.mPercentageDone) {
            this.mPercentageDone = percent;
            for (ProgressListener listener : this.mListeners) {
                listener.progress(this, percent);
            }
        }
    }

    public void addProgressListener(ProgressListener pListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<ProgressListener>();
        }
        this.mListeners.add(pListener);
    }

    public void removeProgressListener(ProgressListener pListener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(pListener);
    }

    public void removeAllProgressListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
        }
    }

    private static short[] toShortPixels(int[] pPixels) {
        short[] pixels = new short[pPixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (short)(pPixels[i] & 0xFFFF);
        }
        return pixels;
    }

    private class Consumer
    implements ImageConsumer {
        private Consumer() {
        }

        private void setPixelsImpl(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, Object pPixels, int pOffset, int pScanSize) {
            int diff;
            this.setColorModelOnce(pModel);
            if (pPixels == null) {
                return;
            }
            if (BufferedImageFactory.this.mSourcePixels == null) {
                BufferedImageFactory.this.mSourcePixels = Array.newInstance(pPixels.getClass().getComponentType(), BufferedImageFactory.this.mWidth * BufferedImageFactory.this.mHeight);
                BufferedImageFactory.this.mScanSize = BufferedImageFactory.this.mWidth;
                BufferedImageFactory.this.mOffset = 0;
            } else if (BufferedImageFactory.this.mSourcePixels.getClass() != pPixels.getClass()) {
                throw new IllegalStateException("Only one pixel type allowed");
            }
            if (pY < BufferedImageFactory.this.mY) {
                diff = BufferedImageFactory.this.mY - pY;
                if (diff >= pHeight) {
                    return;
                }
                pOffset += pScanSize * diff;
                pY += diff;
                pHeight -= diff;
            }
            if (pY + pHeight > BufferedImageFactory.this.mY + BufferedImageFactory.this.mHeight && (pHeight = BufferedImageFactory.this.mY + BufferedImageFactory.this.mHeight - pY) <= 0) {
                return;
            }
            if (pX < BufferedImageFactory.this.mX) {
                diff = BufferedImageFactory.this.mX - pX;
                if (diff >= pWidth) {
                    return;
                }
                pOffset += diff;
                pX += diff;
                pWidth -= diff;
            }
            if (pX + pWidth > BufferedImageFactory.this.mX + BufferedImageFactory.this.mWidth && (pWidth = BufferedImageFactory.this.mX + BufferedImageFactory.this.mWidth - pX) <= 0) {
                return;
            }
            int dstOffset = BufferedImageFactory.this.mOffset + (pY - BufferedImageFactory.this.mY) * BufferedImageFactory.this.mScanSize + (pX - BufferedImageFactory.this.mX);
            for (int i = pHeight; i > 0; --i) {
                System.arraycopy(pPixels, pOffset, BufferedImageFactory.this.mSourcePixels, dstOffset, pWidth);
                pOffset += pScanSize;
                dstOffset += BufferedImageFactory.this.mScanSize;
            }
            BufferedImageFactory.this.processProgress(pY + pHeight);
        }

        public void setPixels(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, short[] pPixels, int pOffset, int pScanSize) {
            this.setPixelsImpl(pX, pY, pWidth, pHeight, pModel, pPixels, pOffset, pScanSize);
        }

        private void setColorModelOnce(ColorModel pModel) {
            if (BufferedImageFactory.this.mSourceColorModel != pModel) {
                if (BufferedImageFactory.this.mSourcePixels == null) {
                    BufferedImageFactory.this.mSourceColorModel = pModel;
                } else {
                    throw new IllegalStateException("Change of ColorModel after pixel delivery not supported");
                }
            }
            if (BufferedImageFactory.this.mReadColorModelOnly) {
                BufferedImageFactory.this.mConsumer.imageComplete(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void imageComplete(int pStatus) {
            BufferedImageFactory.this.mFetching = false;
            if (BufferedImageFactory.this.mProducer != null) {
                BufferedImageFactory.this.mProducer.removeConsumer(this);
            }
            switch (pStatus) {
                case 1: {
                    new Error().printStackTrace();
                    BufferedImageFactory.this.mError = true;
                }
            }
            BufferedImageFactory bufferedImageFactory = BufferedImageFactory.this;
            synchronized (bufferedImageFactory) {
                BufferedImageFactory.this.notifyAll();
            }
        }

        public void setColorModel(ColorModel pModel) {
            this.setColorModelOnce(pModel);
        }

        public void setDimensions(int pWidth, int pHeight) {
            if (BufferedImageFactory.this.mWidth < 0) {
                BufferedImageFactory.this.mWidth = pWidth - BufferedImageFactory.this.mX;
            }
            if (BufferedImageFactory.this.mHeight < 0) {
                BufferedImageFactory.this.mHeight = pHeight - BufferedImageFactory.this.mY;
            }
            if (BufferedImageFactory.this.mWidth <= 0 || BufferedImageFactory.this.mHeight <= 0) {
                this.imageComplete(3);
            }
        }

        public void setHints(int pHintflags) {
        }

        public void setPixels(int pX, int pY, int pWidth, int pHeight, ColorModel pModel, byte[] pPixels, int pOffset, int pScanSize) {
            this.setPixelsImpl(pX, pY, pWidth, pHeight, pModel, pPixels, pOffset, pScanSize);
        }

        public void setPixels(int pX, int pY, int pWeigth, int pHeight, ColorModel pModel, int[] pPixels, int pOffset, int pScanSize) {
            if (ImageUtil.getTransferType(pModel) == 1) {
                this.setPixelsImpl(pX, pY, pWeigth, pHeight, pModel, BufferedImageFactory.toShortPixels(pPixels), pOffset, pScanSize);
            } else {
                this.setPixelsImpl(pX, pY, pWeigth, pHeight, pModel, pPixels, pOffset, pScanSize);
            }
        }

        public void setProperties(Hashtable pProperties) {
            BufferedImageFactory.this.mSourceProperties = pProperties;
        }
    }

    public static interface ProgressListener
    extends EventListener {
        public void progress(BufferedImageFactory var1, float var2);
    }
}

