/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class BufferedImageIcon
implements Icon {
    private final BufferedImage mImage;
    private int mWidth;
    private int mHeight;
    private final boolean mFast;

    public BufferedImageIcon(BufferedImage pImage) {
        this(pImage, pImage.getWidth(), pImage.getHeight());
    }

    public BufferedImageIcon(BufferedImage pImage, int pWidth, int pHeight) {
        if (pImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (pWidth <= 0 || pHeight <= 0) {
            throw new IllegalArgumentException("Icon size must be positive");
        }
        this.mImage = pImage;
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        this.mFast = pImage.getWidth() == this.mWidth && pImage.getHeight() == this.mHeight;
    }

    public int getIconHeight() {
        return this.mHeight;
    }

    public int getIconWidth() {
        return this.mWidth;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.mFast || !(g instanceof Graphics2D)) {
            g.drawImage(this.mImage, x, y, this.mWidth, this.mHeight, null);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            xform.scale((double)this.mWidth / (double)this.mImage.getWidth(), (double)this.mHeight / (double)this.mImage.getHeight());
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(this.mImage, xform, null);
        }
    }
}

