/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.Win32File;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

final class Win32Lnk
extends File {
    private static final byte[] LNK_MAGIC = new byte[]{76, 0, 0, 0};
    private static final byte[] LNK_GUID = new byte[]{1, 20, 2, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    private final File mTarget;
    private static final int FLAG_ITEM_ID_LIST = 1;
    private static final int FLAG_FILE_LOC_INFO = 2;
    private static final int FLAG_DESC_STRING = 4;
    private static final int FLAG_REL_PATH_STRING = 8;
    private static final int FLAG_WORKING_DIRECTORY = 16;
    private static final int FLAG_COMMAND_LINE_ARGS = 32;
    private static final int FLAG_ICON_FILENAME = 64;
    private static final int FLAG_ADDITIONAL_INFO = 128;

    private Win32Lnk(String pPath) throws IOException {
        super(pPath);
        File target = Win32Lnk.parse(this);
        if (target == this) {
            target = new File(pPath);
        }
        this.mTarget = target;
    }

    Win32Lnk(File pPath) throws IOException {
        this(pPath.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File parse(File pPath) throws IOException {
        if (!pPath.getName().endsWith(".lnk")) {
            return pPath;
        }
        File result = pPath;
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(pPath)));
        try {
            byte[] magic = new byte[4];
            in.readFully(magic);
            byte[] guid = new byte[16];
            in.readFully(guid);
            if (!Arrays.equals(LNK_MAGIC, magic) || !Arrays.equals(LNK_GUID, guid)) {
                File file = pPath;
                return file;
            }
            int flags = in.readInt();
            in.readInt();
            in.skipBytes(48);
            if ((flags & 1) != 0) {
                short shellLen = in.readShort();
                in.skipBytes(shellLen);
            }
            if ((flags & 2) != 0) {
                int tableLen = in.readInt();
                in.readInt();
                int locFlags = in.readInt();
                if ((locFlags & 1) != 0) {
                    // empty if block
                }
                if ((locFlags & 2) != 0) {
                    // empty if block
                }
                in.skipBytes(4);
                int localSysOff = in.readInt();
                in.skipBytes(localSysOff - 20);
                byte[] pathBytes = new byte[tableLen - localSysOff - 1];
                in.readFully(pathBytes, 0, pathBytes.length);
                String path = new String(pathBytes, 0, pathBytes.length - 1);
                try {
                    result = Win32Lnk.parse(new File(path));
                }
                catch (StackOverflowError e) {
                    throw new IOException("Cannot resolve cyclic link: " + e.getMessage());
                }
            }
            if ((flags & 4) != 0) {
                short descLen = in.readShort();
                byte[] descBytes = new byte[descLen];
                in.readFully(descBytes, 0, descLen);
            }
            if ((flags & 8) != 0) {
                short pathLen = in.readShort();
                byte[] pathBytes = new byte[pathLen];
                in.readFully(pathBytes, 0, pathLen);
                String path = new String(pathBytes, 0, (int)pathLen);
                if (result == pPath) {
                    try {
                        result = Win32Lnk.parse(new File(pPath.getParentFile(), path));
                    }
                    catch (StackOverflowError e) {
                        throw new IOException("Cannot resolve cyclic link: " + e.getMessage());
                    }
                }
            }
            if ((flags & 0x10) != 0) {
                // empty if block
            }
            if ((flags & 0x20) != 0) {
                result = pPath;
            }
            if ((flags & 0x40) != 0) {
                // empty if block
            }
            if ((flags & 0x80) != 0) {
                // empty if block
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public File getTarget() {
        return this.mTarget;
    }

    public boolean isDirectory() {
        return this.mTarget.isDirectory();
    }

    public boolean canRead() {
        return this.mTarget.canRead();
    }

    public boolean canWrite() {
        return this.mTarget.canWrite();
    }

    public boolean exists() {
        return this.mTarget.exists();
    }

    public File getCanonicalFile() throws IOException {
        return this.mTarget.getCanonicalFile();
    }

    public String getCanonicalPath() throws IOException {
        return this.mTarget.getCanonicalPath();
    }

    public boolean isFile() {
        return this.mTarget.isFile();
    }

    public boolean isHidden() {
        return this.mTarget.isHidden();
    }

    public long lastModified() {
        return this.mTarget.lastModified();
    }

    public long length() {
        return this.mTarget.length();
    }

    public String[] list() {
        return this.mTarget.list();
    }

    public String[] list(FilenameFilter filter) {
        return this.mTarget.list(filter);
    }

    public File[] listFiles() {
        return Win32File.wrap(this.mTarget.listFiles());
    }

    public File[] listFiles(FileFilter filter) {
        return Win32File.wrap(this.mTarget.listFiles(filter));
    }

    public File[] listFiles(FilenameFilter filter) {
        return Win32File.wrap(this.mTarget.listFiles(filter));
    }

    public boolean setLastModified(long time) {
        return this.mTarget.setLastModified(time);
    }

    public boolean setReadOnly() {
        return this.mTarget.setReadOnly();
    }

    public String toString() {
        if (this.mTarget.equals(this)) {
            return super.toString();
        }
        return super.toString() + " -> " + this.mTarget.toString();
    }
}

