/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.AbstractRLEDecoder;
import java.io.IOException;
import java.io.InputStream;

final class RLE8Decoder
extends AbstractRLEDecoder {
    public RLE8Decoder(int pWidth, int pHeight) {
        super(pWidth, pHeight);
    }

    protected void decodeRow(InputStream pInput) throws IOException {
        int deltaX = 0;
        int deltaY = 0;
        while (this.mSrcY >= 0) {
            block13: {
                int byte2;
                int byte1;
                block12: {
                    byte1 = pInput.read();
                    byte2 = RLE8Decoder.checkEOF(pInput.read());
                    if (byte1 != 0) break block12;
                    switch (byte2) {
                        case 0: {
                            if (this.mSrcX != 0) {
                                this.mSrcX = this.mRow.length;
                                break;
                            }
                            break block13;
                        }
                        case 1: {
                            this.mSrcX = this.mRow.length;
                            this.mSrcY = 0;
                            break;
                        }
                        case 2: {
                            deltaX = this.mSrcX + pInput.read();
                            deltaY = this.mSrcY - RLE8Decoder.checkEOF(pInput.read());
                            this.mSrcX = this.mRow.length;
                            break;
                        }
                        default: {
                            boolean paddingByte;
                            boolean bl = paddingByte = byte2 % 2 != 0;
                            while (byte2-- > 0) {
                                this.mRow[this.mSrcX++] = (byte)RLE8Decoder.checkEOF(pInput.read());
                            }
                            if (paddingByte) {
                                RLE8Decoder.checkEOF(pInput.read());
                                break;
                            }
                            break block13;
                        }
                    }
                    break block13;
                }
                byte value = (byte)byte2;
                while (byte1-- > 0) {
                    this.mRow[this.mSrcX++] = value;
                }
            }
            if (this.mSrcX != this.mRow.length) continue;
            if (deltaX != 0 || deltaY != 0) {
                this.mSrcX = deltaX;
                if (deltaY != this.mSrcY) {
                    this.mSrcY = deltaY;
                    break;
                }
                deltaX = 0;
                deltaY = 0;
                continue;
            }
            this.mSrcX = 0;
            --this.mSrcY;
            break;
        }
    }
}

