/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.regex;

import com.twelvemonkeys.util.AbstractTokenIterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExTokenIterator
extends AbstractTokenIterator {
    private final Matcher mMatcher;
    private boolean mNext = false;

    public RegExTokenIterator(String pString) {
        this(pString, "\\S+");
    }

    public RegExTokenIterator(String pString, String pPattern) {
        if (pString == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (pPattern == null) {
            throw new IllegalArgumentException("pattern == null");
        }
        this.mMatcher = Pattern.compile(pPattern).matcher(pString);
    }

    public void reset() {
        this.mMatcher.reset();
    }

    public boolean hasNext() {
        return this.mNext || (this.mNext = this.mMatcher.find());
    }

    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.mNext = false;
        return this.mMatcher.group();
    }
}

