//
//  Twilio Conversations Client
//
//  Copyright © Twilio, Inc. All rights reserved.
//
package com.twilio.conversations;

import com.twilio.util.ErrorInfo;

/**
 * Listener interface for a generic listener object.
 * <p>
 * This interface is implemented as an abstract class with already defined (empty) body
 * for {@link #onError}. You are only required to define {@link #onSuccess}.
 * <p>
 * Callback listeners are always called on the originating thread or on main UI thread if
 * the originating thread did not have a Looper.
 */
public interface CallbackListener<T> {

    /**
     * Callback to report success status of an asynchronous call to the back end.
     * @param result Successful return value.
     */
    void onSuccess(T result);

    /**
     * Callback to report error status of an asynchronous call to the back end.
     *
     * @param errorInfo Object containing error information.
     */
    default void onError(ErrorInfo errorInfo) {}
}
