//
//  Twilio Conversations Client
//
//  Copyright © Twilio, Inc. All rights reserved.
//
package com.twilio.conversations;

/**
 * Interface for cancelling a network request.
 */
public interface CancellationToken {

    /**
     * Cancels the network request.
     * <p>
     * Request could be already transmitted to the backend or not.
     * In case when it has been transmitted cancellation doesn't
     * rollback any actions made by request, just ignores the response.
     */
    void cancel();
}
