package com.twilio.conversations

/** Limits for attachments per each message in a conversation. */
data class ConversationLimits(

    /** Maximum number of attachments per message. */
    val mediaAttachmentsCountLimit: Int,

    /** Maximum size of each attachment. */
    val mediaAttachmentSizeLimitInMb: Int,

    /** Maximum total size of all attachments of one message. */
    val mediaAttachmentsTotalSizeLimitInMb: Int,

    /** List of contentTypes supported for email body. */
    val emailBodiesAllowedContentTypes: List<String>,

    /** List of contentTypes supported for email history. */
    val emailHistoriesAllowedContentTypes: List<String>,
)
