//
//  Twilio Conversations Client
//
//  Copyright © Twilio, Inc. All rights reserved.
//
package com.twilio.conversations

import java.lang.RuntimeException

/**
 * ListenerException is thrown when exception occurred in app code that implements one of the Twilio Conversations
 * SDK listeners, i.e in implementation of [ConversationsClientListener], [ConversationListener], [StatusListener],
 * [CallbackListener], [MediaUploadListener] etc.
 *
 * Use [Throwable.cause] to access the original exception thrown by app.
 */
class ListenerException internal constructor(t: Throwable?) : RuntimeException(
    "Exception thrown by a listener. Your application might have a problem in listener implementation. " +
            "Listeners must never throw uncaught exceptions. See 'Caused by:' below for more details.", t
)
