package com.twilio.conversations

/**
 * A Media represents media information of a Message in a Conversation.
 */
interface Media {

    /** The server-assigned unique identifier for Media. */
    val sid: String

    /** Content type of media. */
    val contentType: String

    /** Media category, can be one of the [MediaCategory] values. */
    val category: MediaCategory

    /** File name if present, empty string otherwise. */
    val filename: String?

    /** Size of media, bytes. */
    val size: Long

    /**
     * Returns direct content URL for the media.
     *
     * This URL is impermanent, it will expire in several minutes and cannot be cached.
     * If the URL becomes expired, you need to request a new one.
     * Each call to this function produces a new temporary URL.
     *
     * @param listener Listener to receive temporary URL.
     * @return [CancellationToken] which allows to cancel network request.
     */
    fun getTemporaryContentUrl(listener: CallbackListener<String>): CancellationToken
}
