//
//  Twilio Conversations Client
//
//  Copyright © Twilio, Inc. All rights reserved.
//
package com.twilio.conversations;

import com.twilio.util.ErrorInfo;

/**
 * Interface for a generic listener object.
 * <p>
 * This interface is implemented as an abstract class with already defined (empty) body
 * for {@link #onError}. You are only required to define {@link #onSuccess}.
 * <p>
 * Status listeners are always called on the originating thread or on main UI thread if
 * the originating thread did not have a Looper.
 */
/*!
 * You could wrap your call in a Handler invocation with a specific thread e.g.
 *
 * ```java
 * Handler handler = new Handler(someOtherThreadLooper);
 * handler.post(new Runnable() {
 *     @Override
 *     public void run() {
 *         client.getConversations().getUserConversationsList(myListener);
 *     }
 * });
 * ```
 *
 * Then myListener will be invoked on someOtherThread. Note that your thread has to have an event
 * Looper to be able to run callbacks.
 */
public interface StatusListener {

    /**
     * Callback to report success status of an asynchronous call to the back end.
     */
    void onSuccess();

    /**
     * Callback to report error status of an asynchronous call to the back end.
     *
     * @param errorInfo Object containing error information.
     */
    default void onError(ErrorInfo errorInfo) {}
}
