/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.ConversationsClientImpl;
import com.twilio.conversations.ConversationsClientListener;
import com.twilio.conversations.Media;
import com.twilio.conversations.NotificationPayload;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.User;
import com.twilio.conversations.content.ContentTemplate;
import java.util.List;
import java.util.Map;

public interface ConversationsClient {
    public static void setLogLevel(LogLevel level) {
        ConversationsClientImpl.setLogLevel(level.mValue);
    }

    public static void create(@NonNull Context context, @NonNull String token, @NonNull Properties properties, @NonNull CallbackListener<ConversationsClient> listener) {
        ConversationsClientImpl.create(context, token, properties, listener);
    }

    public static String getSdkVersion() {
        return ConversationsClientImpl.getSdkVersion();
    }

    public Properties getProperties();

    public void updateToken(String var1, StatusListener var2);

    public void shutdown();

    public void addListener(@NonNull ConversationsClientListener var1);

    public void removeListener(@NonNull ConversationsClientListener var1);

    public void removeAllListeners();

    public void registerFCMToken(FCMToken var1, StatusListener var2);

    public void unregisterFCMToken(FCMToken var1, StatusListener var2);

    public void handleNotification(NotificationPayload var1);

    public ConnectionState getConnectionState();

    public String getMyIdentity();

    public List<Participant> getParticipantsByIdentity(String var1);

    public void getAndSubscribeUser(String var1, CallbackListener<User> var2);

    public List<User> getSubscribedUsers();

    public User getMyUser();

    public void createConversation(String var1, CallbackListener<Conversation> var2);

    public ConversationBuilder conversationBuilder();

    public void getConversation(String var1, CallbackListener<Conversation> var2);

    public List<Conversation> getMyConversations();

    public boolean isReachabilityEnabled();

    @NonNull
    public CancellationToken getTemporaryContentUrlsForMedia(@NonNull List<Media> var1, @NonNull CallbackListener<Map<String, String>> var2);

    @NonNull
    public CancellationToken getTemporaryContentUrlsForMediaSids(@NonNull List<String> var1, @NonNull CallbackListener<Map<String, String>> var2);

    @NonNull
    public CancellationToken getContentTemplates(@NonNull CallbackListener<List<ContentTemplate>> var1);

    public static enum LogLevel {
        VERBOSE(2),
        DEBUG(3),
        INFO(4),
        WARN(5),
        ERROR(6),
        ASSERT(7),
        SILENT(8);

        final int mValue;

        private LogLevel(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public static LogLevel fromInt(int value) {
            for (LogLevel item : LogLevel.values()) {
                if (item.getValue() != value) continue;
                return item;
            }
            throw new IllegalStateException("Invalid value " + value + " for LogLevel");
        }
    }

    public static interface Properties {
        public static final int MIN_COMMAND_TIMEOUT = 10000;
        public static final int DEFAULT_COMMAND_TIMEOUT = 10000;

        public static Builder newBuilder() {
            return new ConversationsClientImpl.PropertiesImpl.BuilderImpl();
        }

        public String getRegion();

        public boolean useProxy();

        public boolean getDeferCA();

        public int getCommandTimeout();

        public static interface Builder {
            public Builder setRegion(String var1);

            public Builder setUseProxy(boolean var1);

            public Builder setDeferCertificateTrustToPlatform(boolean var1);

            public Builder setCommandTimeout(int var1);

            public Properties createProperties();
        }
    }

    public static class FCMToken {
        private final String token;

        public FCMToken(String token) {
            if (TextUtils.isEmpty((CharSequence)token)) {
                throw new IllegalArgumentException("Token must not be empty");
            }
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }

    public static interface ConversationBuilder {
        public ConversationBuilder withFriendlyName(String var1);

        public ConversationBuilder withUniqueName(String var1);

        public ConversationBuilder withAttributes(@NonNull Attributes var1);

        public void build(CallbackListener<Conversation> var1);
    }

    public static enum ConnectionState {
        CONNECTING(0),
        CONNECTED(1),
        DISCONNECTED(2),
        DENIED(3),
        ERROR(4),
        FATAL_ERROR(5);

        private final int value;

        private ConnectionState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionState fromInt(int value) {
            for (ConnectionState t : ConnectionState.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for ConnectionState");
        }
    }

    public static enum SynchronizationStatus {
        STARTED(0),
        CONVERSATIONS_COMPLETED(1),
        COMPLETED(2),
        FAILED(3);

        private final int value;

        private SynchronizationStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SynchronizationStatus fromInt(int value) {
            for (SynchronizationStatus t : SynchronizationStatus.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for SynchronizationStatus");
        }
    }
}

