/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.Conversations;
import com.twilio.conversations.ConversationsClient;
import com.twilio.conversations.ConversationsClientListener;
import com.twilio.conversations.Disposable;
import com.twilio.conversations.Media;
import com.twilio.conversations.NotificationPayload;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.User;
import com.twilio.conversations.Users;
import com.twilio.conversations.content.ContentClient;
import com.twilio.conversations.content.ContentClientExtensionsKt;
import com.twilio.conversations.content.ContentClientFactoryKt;
import com.twilio.conversations.content.ContentTemplate;
import com.twilio.conversations.extensions.MediaClientExtensionsKt;
import com.twilio.conversations.internal.CallbackListenerForwarder;
import com.twilio.conversations.internal.ConversationsClientListenerForwarder;
import com.twilio.conversations.internal.JSONObjectUtils;
import com.twilio.conversations.internal.StatusListenerForwarder;
import com.twilio.conversations.internal.Utils;
import com.twilio.conversations.media.MediaClient;
import com.twilio.conversations.media.MediaFactoryKt;
import com.twilio.conversations.twilsock.TwilsockWrapper;
import com.twilio.twilsock.client.Twilsock;
import com.twilio.twilsock.commands.CommandsConfig;
import com.twilio.twilsock.commands.CommandsConfigKt;
import com.twilio.twilsock.commands.CommandsScheduler;
import com.twilio.util.ApplicationContextHolder;
import com.twilio.util.ErrorInfo;
import com.twilio.util.TwilioLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

final class ConversationsClientImpl
implements Disposable,
ConversationsClient {
    private static final AtomicBoolean libraryIsLoaded = new AtomicBoolean(false);
    private static final TwilioLogger logger = TwilioLogger.getLogger((KClass)JvmClassMappingKt.getKotlinClass(ConversationsClientImpl.class));
    private final CoroutineScope coroutineScope = new CoroutineScope(){

        @NotNull
        public CoroutineContext getCoroutineContext() {
            return Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob(null));
        }
    };
    private Context context;
    private CommandsScheduler commandsScheduler;
    private MediaClient mediaClient;
    private ContentClient contentClient;
    private String identity;
    private StatusListener pushRegistrationStatusListener;
    private StatusListenerForwarder appPushRegistrationStatusListener;
    private LifecycleListener lifecycleListener;
    private LifecycleListener2 lifecycleListener2;
    private ConversationsClientListenerForwarder listenerForwarder;
    private long nativeHandle;
    private boolean isDisposed = false;
    private boolean wasBackgrounded = false;
    private ConversationsClient.Properties properties;

    private static synchronized void loadNativeLibraries(Context context) {
        if (!libraryIsLoaded.getAndSet(true)) {
            ReLinker.loadLibrary((Context)context.getApplicationContext(), (String)"twilio-convo-native");
        }
    }

    private native void reconnect(long var1);

    public static String getSdkVersion() {
        return "6.0.3-0330c4f7c";
    }

    private static void dumpSdkVersion() {
        logger.info("Twilio Conversations SDK version " + ConversationsClientImpl.getSdkVersion());
    }

    public static void create(@NonNull Context context, @NonNull String token, @NonNull ConversationsClient.Properties properties, @NonNull CallbackListener<ConversationsClient> listener) {
        if (listener == null) {
            throw new IllegalStateException("Listener cannot be null in ConversationsClient constructor");
        }
        ApplicationContextHolder.setApplicationContext((Context)context.getApplicationContext());
        new ConversationsClientImpl(context, token, properties, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder fallbackCopy(Context context) throws IOException {
        int res = context.getResources().getIdentifier("rootcert", "raw", context.getPackageName());
        StringBuilder out = new StringBuilder();
        try (InputStream inputStream = context.getResources().openRawResource(res);){
            int rsz;
            int bufferSize = 4096;
            char[] buffer = new char[4096];
            InputStreamReader in = new InputStreamReader(inputStream, "UTF-8");
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        return out;
    }

    private String readCertificateStore(Context context, ConversationsClient.Properties properties) {
        StringBuilder certificates;
        block11: {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            boolean chainIncomplete = false;
            if (properties.getDeferCA()) {
                try {
                    TrustManagerFactory factory = TrustManagerFactory.getInstance("X509");
                    factory.init((KeyStore)null);
                    for (TrustManager tm : factory.getTrustManagers()) {
                        X509TrustManager sslTrustManager = (X509TrustManager)tm;
                        if (sslTrustManager == null) continue;
                        certs.addAll(Arrays.asList(sslTrustManager.getAcceptedIssuers()));
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    chainIncomplete = true;
                }
                catch (KeyStoreException ex) {
                    chainIncomplete = true;
                }
            }
            certificates = new StringBuilder();
            try {
                if (certs.size() == 0 || chainIncomplete || !properties.getDeferCA()) {
                    certificates = this.fallbackCopy(context);
                    break block11;
                }
                try {
                    for (X509Certificate c : certs) {
                        certificates.append("\n-----BEGIN CERTIFICATE-----\n" + Base64.encodeToString((byte[])c.getEncoded(), (int)0) + "-----END CERTIFICATE-----\n");
                    }
                }
                catch (CertificateEncodingException ex) {
                    logger.e("SSL CA store error - fallback to default", (Throwable)ex);
                    certificates = this.fallbackCopy(context);
                }
            }
            catch (IOException ex) {
                logger.e("Unable to install SSL certificate - connections will fail");
            }
        }
        return certificates.toString();
    }

    private ConversationsClientImpl(Context context, final String token, ConversationsClient.Properties properties, final CallbackListener<ConversationsClient> initListener) {
        if (context == null) {
            throw new IllegalStateException("Context cannot be null in ConversationsClient constructor");
        }
        if (token == null) {
            throw new IllegalStateException("Token cannot be null in ConversationsClient constructor");
        }
        if (properties == null) {
            throw new IllegalStateException("Properties cannot be null in ConversationsClient constructor");
        }
        if (initListener == null) {
            throw new IllegalStateException("Listener cannot be null in ConversationsClient constructor");
        }
        ConversationsClientImpl.loadNativeLibraries(context);
        ConversationsClientImpl.dumpSdkVersion();
        ConversationsClientImpl.nativeSetLogLevel(TwilioLogger.getLogLevel());
        Application application = (Application)context.getApplicationContext();
        this.lifecycleListener = new LifecycleListener(application);
        this.lifecycleListener2 = new LifecycleListener2(application);
        this.listenerForwarder = new ConversationsClientListenerForwarder();
        this.properties = properties;
        this.context = context;
        this.pushRegistrationStatusListener = new StatusListener(){

            @Override
            public void onError(ErrorInfo errorInfo) {
                if (ConversationsClientImpl.this.appPushRegistrationStatusListener != null) {
                    ConversationsClientImpl.this.appPushRegistrationStatusListener.onError(errorInfo);
                }
            }

            @Override
            public void onSuccess() {
                if (ConversationsClientImpl.this.appPushRegistrationStatusListener != null) {
                    ConversationsClientImpl.this.appPushRegistrationStatusListener.onSuccess();
                }
            }
        };
        final String certs = this.readCertificateStore(context, properties);
        ClientMetadata md = new ClientMetadata();
        md.os = "Android";
        md.osv = Build.VERSION.RELEASE;
        md.osa = System.getProperty("os.arch");
        md.dev = Utils.getDeviceName();
        md.devv = Utils.getDeviceManufacturer();
        md.devt = Utils.getDeviceType();
        md.app = Utils.getAppName(context);
        md.appv = Utils.getAppVersion(context);
        md.sdk = "Android";
        md.sdkv = "6.0.3-0330c4f7c";
        if (properties instanceof PropertiesImpl) {
            PropertiesImpl propertiesImpl = (PropertiesImpl)properties;
            md.env = propertiesImpl._sysPropGet("env");
            md.envv = propertiesImpl._sysPropGet("envv");
            md.app = propertiesImpl._sysPropGet("app");
            md.appv = propertiesImpl._sysPropGet("appv");
        }
        logger.d("BOARD " + Build.BOARD);
        logger.d("BRAND " + Build.BRAND);
        logger.d("DEVICE " + Build.DEVICE);
        logger.d("DISPLAY " + Build.DISPLAY);
        logger.d("FINGERPRINT " + Build.FINGERPRINT);
        logger.d("HARDWARE " + Build.HARDWARE);
        logger.d("MANUFACTURER " + Build.MANUFACTURER);
        logger.d("MODEL " + Build.MODEL);
        logger.d("PRODUCT " + Build.PRODUCT);
        CallbackListener<ConversationsClient> initListenerForwarder = new CallbackListener<ConversationsClient>(){

            @Override
            public void onSuccess(ConversationsClient value) {
                ConversationsClientImpl.this.initCommandsScheduler();
                ConversationsClientImpl.this.initContentClient();
                ConversationsClientImpl.this.initMediaClient(token, certs);
                initListener.onSuccess(value);
            }

            @Override
            public void onError(ErrorInfo error) {
                logger.w("Failed to initialize ConversationsClient: " + error);
                ConversationsClientImpl.this.shutdown();
                initListener.onError(error);
            }
        };
        this.nativeHandle = this.nativeCreate(this.listenerForwarder, new CallbackListenerForwarder<ConversationsClient>(initListenerForwarder), this.pushRegistrationStatusListener, token, md, properties, certs);
        logger.d("constructed");
    }

    private void initCommandsScheduler() {
        CommandsConfig commandsConfig = CommandsConfigKt.newCommandsConfig();
        TwilsockWrapper twilsockWrapper = this.nativeGetTwilsockWrapper();
        Twilsock twilsock = twilsockWrapper.getTwilsock();
        this.commandsScheduler = new CommandsScheduler(this.coroutineScope, twilsock, commandsConfig);
    }

    private void initContentClient() {
        String contentTemplatesUrl = String.format("https://aim.%s.twilio.com/Client/v2/ContentTemplates", this.properties.getRegion());
        this.contentClient = ContentClientFactoryKt.createContentClient(this.coroutineScope, this.commandsScheduler, contentTemplatesUrl);
    }

    private void initMediaClient(String token, String certificates) {
        MediaSettings mediaSettings = this.nativeGetMediaSettings();
        this.mediaClient = MediaFactoryKt.createMediaClient(mediaSettings.serviceUrl, mediaSettings.mediaSetUrl, mediaSettings.productId, token, certificates, mediaSettings.activeUploadsLimit, mediaSettings.loadTimeoutMs, this.properties.useProxy());
    }

    @Override
    public ConversationsClient.Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateToken(final String token, StatusListener listener) {
        this.checkDisposed("updateToken");
        if (token != null) {
            ConversationsClientImpl conversationsClientImpl = this;
            synchronized (conversationsClientImpl) {
                logger.d("Calling update Token");
                this.nativeUpdateToken(token, this.nativeHandle, new StatusListenerForwarder(listener){

                    @Override
                    public void onSuccess() {
                        ConversationsClientImpl.this.mediaClient.updateToken(token);
                        super.onSuccess();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        logger.d("shutdown");
        this.checkDisposed("shutdown");
        ConversationsClientImpl conversationsClientImpl = this;
        synchronized (conversationsClientImpl) {
            this.lifecycleListener.unregister();
            this.lifecycleListener = null;
            this.lifecycleListener2.unregister();
            this.lifecycleListener2 = null;
            this.nativeShutdown(this.nativeHandle);
            CoroutineScopeKt.cancel((CoroutineScope)this.coroutineScope, null);
            this.dispose();
        }
    }

    @Override
    public void addListener(@NonNull ConversationsClientListener listener) {
        this.listenerForwarder.addListener(listener);
    }

    @Override
    public void removeListener(@NonNull ConversationsClientListener listener) {
        this.listenerForwarder.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listenerForwarder.removeAllListeners();
    }

    @Override
    public void registerFCMToken(ConversationsClient.FCMToken token, StatusListener listener) {
        this.checkDisposed("registerFCMToken");
        this.appPushRegistrationStatusListener = new StatusListenerForwarder(listener);
        this.nativeRegisterToken(this.nativeHandle, token.getToken(), true);
    }

    @Override
    public void unregisterFCMToken(ConversationsClient.FCMToken token, StatusListener listener) {
        this.checkDisposed("unregisterFCMToken");
        this.appPushRegistrationStatusListener = new StatusListenerForwarder(listener);
        this.nativeUnregisterToken(this.nativeHandle, token.getToken(), true);
    }

    @Override
    public void handleNotification(NotificationPayload notification) {
        this.checkDisposed("handleNotification");
        JSONObject jsonObj = new JSONObject();
        Set keys = notification.payload.keySet();
        for (String key : keys) {
            try {
                jsonObj.put(key, JSONObjectUtils.wrap(notification.payload.get(key)));
            }
            catch (JSONException jSONException) {}
        }
        this.nativeHandleNotification(this.nativeHandle, jsonObj.toString());
    }

    @Override
    public native ConversationsClient.ConnectionState getConnectionState();

    @Override
    public native String getMyIdentity();

    private Users getUsers() {
        Users users = this.nativeGetUsers();
        if (users == null) {
            throw new IllegalStateException("Client is not synchronized properly, internal Users object is null.");
        }
        return users;
    }

    @Override
    public void getAndSubscribeUser(String identity, CallbackListener<User> listener) {
        this.checkDisposed("getAndSubscribeUser");
        this.getUsers().nativeGetAndSubscribeUser(identity, new CallbackListenerForwarder<User>(listener));
    }

    @Override
    public List<User> getSubscribedUsers() {
        return this.getUsers().getSubscribedUsers();
    }

    @Override
    public User getMyUser() {
        return this.getUsers().getMyUser();
    }

    private Conversations getConversations() {
        Conversations conversations = this.nativeGetChannels();
        if (conversations == null) {
            throw new IllegalStateException("Client is not synchronized properly, internal Conversations object is null.");
        }
        return conversations;
    }

    @Override
    public void createConversation(String friendlyName, CallbackListener<Conversation> listener) {
        this.getConversations().nativeCreateConversation(friendlyName, null, null, new CallbackListenerForwarder<Conversation>(listener));
    }

    @Override
    public ConversationsClient.ConversationBuilder conversationBuilder() {
        this.checkDisposed("conversationBuilder");
        return new ConversationBuilderImpl(this.getConversations());
    }

    @Override
    public void getConversation(String conversationSidOrUniqueName, CallbackListener<Conversation> listener) {
        this.checkDisposed("getConversation");
        this.getConversations().nativeGetConversation(conversationSidOrUniqueName, new CallbackListenerForwarder<Conversation>(listener));
    }

    @Override
    public List<Conversation> getMyConversations() {
        return this.getConversations().nativeGetMyConversations();
    }

    @Override
    public native boolean isReachabilityEnabled();

    @Override
    @NonNull
    public CancellationToken getTemporaryContentUrlsForMedia(@NonNull List<Media> media, @NonNull CallbackListener<Map<String, String>> listener) {
        return MediaClientExtensionsKt.getTemporaryContentUrlsForMedia(this.mediaClient, this.coroutineScope, media, listener);
    }

    @Override
    @NonNull
    public CancellationToken getTemporaryContentUrlsForMediaSids(@NonNull List<String> mediaSids, @NonNull CallbackListener<Map<String, String>> listener) {
        return MediaClientExtensionsKt.getTemporaryContentUrlsForMediaSids(this.mediaClient, this.coroutineScope, mediaSids, listener);
    }

    @Override
    @NonNull
    public CancellationToken getContentTemplates(@NonNull CallbackListener<List<ContentTemplate>> listener) {
        return ContentClientExtensionsKt.getContentTemplates(this.contentClient, this.coroutineScope, listener);
    }

    @Override
    public List<Participant> getParticipantsByIdentity(String identity) {
        return this.getConversations().nativeGetMembersByIdentity(identity);
    }

    private native void simulateCrash(int var1);

    CommandsScheduler getCommandsScheduler() {
        return this.commandsScheduler;
    }

    MediaClient getMediaClient() {
        return this.mediaClient;
    }

    CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ConversationsClientImpl conversationsClientImpl = this;
        synchronized (conversationsClientImpl) {
            this.checkDisposed("dispose");
            if (!this.isDisposed) {
                this.nativeDispose();
            }
            this.nativeHandle = 0L;
            this.isDisposed = true;
        }
    }

    private void checkDisposed(String method) {
        if (this.isDisposed) {
            logger.e("Attempt to use disposed object in ConversationsClient#" + method);
        }
    }

    public static void setLogLevel(int level) {
        TwilioLogger.setLogLevel((int)level);
    }

    private native long nativeCreate(ConversationsClientListener var1, Object var2, StatusListener var3, String var4, ClientMetadata var5, Object var6, String var7);

    private native Conversations nativeGetChannels();

    private native Users nativeGetUsers();

    private native MediaSettings nativeGetMediaSettings();

    private native TwilsockWrapper nativeGetTwilsockWrapper();

    private native void nativeUpdateToken(String var1, long var2, StatusListener var4);

    private native void nativeShutdown(long var1);

    private native void nativeRegisterToken(long var1, String var3, boolean var4);

    private native void nativeUnregisterToken(long var1, String var3, boolean var4);

    private native void nativeHandleNotification(long var1, String var3);

    private native void nativeDispose();

    private static native void nativeSetLogLevel(int var0);

    private final class LifecycleListener
    implements Application.ActivityLifecycleCallbacks {
        private Application application;

        LifecycleListener(Application app) {
            this.application = app;
            this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            logger.d("Subscribed to ActivityLifecycleCallbacks");
        }

        void unregister() {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.application = null;
            logger.d("Unsubscribed from ActivityLifecycleCallbacks");
        }

        private void checkForegrounded() {
            if (ConversationsClientImpl.this.wasBackgrounded && !ConversationsClientImpl.this.isDisposed) {
                logger.d("Application foregrounded");
                ConversationsClientImpl.this.wasBackgrounded = false;
                ConversationsClientImpl.this.reconnect(ConversationsClientImpl.this.nativeHandle);
            }
        }

        public void onActivityCreated(Activity a, Bundle b) {
            this.checkForegrounded();
        }

        public void onActivityStarted(Activity a) {
            this.checkForegrounded();
        }

        public void onActivityResumed(Activity a) {
            this.checkForegrounded();
        }

        public void onActivityPaused(Activity a) {
        }

        public void onActivityStopped(Activity a) {
        }

        public void onActivityDestroyed(Activity a) {
        }

        public void onActivitySaveInstanceState(Activity a, Bundle b) {
        }
    }

    private final class LifecycleListener2
    implements ComponentCallbacks2 {
        private Application application;

        LifecycleListener2(Application app) {
            this.application = app;
            this.application.registerComponentCallbacks((ComponentCallbacks)this);
            logger.d("Subscribed to ComponentCallbacks2");
        }

        void unregister() {
            this.application.unregisterComponentCallbacks((ComponentCallbacks)this);
            this.application = null;
            logger.d("Unsubscribed from ComponentCallbacks2");
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }

        public void onTrimMemory(int level) {
            if (level == 20) {
                ConversationsClientImpl.this.wasBackgrounded = true;
                logger.d("Application backgrounded");
            }
        }
    }

    private static class ClientMetadata {
        public String env;
        public String envv;
        public String os;
        public String osv;
        public String osa;
        public String dev;
        public String devv;
        public String devt;
        public String app;
        public String appv;
        public String sdk;
        public String sdkv;

        private ClientMetadata() {
        }

        public String getEnv() {
            return this.env;
        }

        public String getEnvv() {
            return this.envv;
        }

        public String getOs() {
            return this.os;
        }

        public String getOsv() {
            return this.osv;
        }

        public String getOsa() {
            return this.osa;
        }

        public String getDev() {
            return this.dev;
        }

        public String getDevv() {
            return this.devv;
        }

        public String getDevt() {
            return this.devt;
        }

        public String getApp() {
            return this.app;
        }

        public String getAppv() {
            return this.appv;
        }

        public String getSdk() {
            return this.sdk;
        }

        public String getSdkv() {
            return this.sdkv;
        }
    }

    public static class PropertiesImpl
    implements ConversationsClient.Properties {
        private final String region;
        private final boolean useProxy;
        private final boolean deferCA;
        private final int commandTimeout;
        private final Map<String, String> sysProps;

        protected PropertiesImpl(String region, boolean useProxy, boolean defer, int commandTimeout, Map<String, String> props) {
            this.region = region;
            this.useProxy = useProxy;
            this.deferCA = defer;
            this.commandTimeout = commandTimeout;
            this.sysProps = props;
        }

        @Override
        public String getRegion() {
            return this.region;
        }

        @Override
        public boolean useProxy() {
            return this.useProxy;
        }

        @Override
        public boolean getDeferCA() {
            return this.deferCA;
        }

        @Override
        public int getCommandTimeout() {
            return this.commandTimeout;
        }

        public String _sysPropGet(String k) {
            return this.sysProps.get(k);
        }

        public static class BuilderImpl
        implements ConversationsClient.Properties.Builder {
            private String region = "us1";
            private boolean useProxy;
            private boolean deferCA;
            private int commandTimeout = 10000;
            private Map<String, String> sysProps = new HashMap<String, String>();

            @Override
            public ConversationsClient.Properties.Builder setRegion(String region) {
                this.region = region;
                return this;
            }

            @Override
            public ConversationsClient.Properties.Builder setUseProxy(boolean useProxy) {
                this.useProxy = useProxy;
                return this;
            }

            @Override
            public ConversationsClient.Properties.Builder setDeferCertificateTrustToPlatform(boolean defer) {
                this.deferCA = defer;
                return this;
            }

            @Override
            public ConversationsClient.Properties.Builder setCommandTimeout(int commandTimeout) {
                if (commandTimeout < 10000) {
                    throw new IllegalArgumentException("Command timeout must be greater than or equal to 10000");
                }
                this.commandTimeout = commandTimeout;
                return this;
            }

            public void _sysPropSet(String k, String v) {
                this.sysProps.put(k, v);
            }

            @Override
            public ConversationsClient.Properties createProperties() {
                return new PropertiesImpl(this.region, this.useProxy, this.deferCA, this.commandTimeout, this.sysProps);
            }
        }
    }

    private static class MediaSettings {
        final String serviceUrl;
        final String mediaSetUrl;
        final String productId;
        final int loadTimeoutMs;
        final int activeUploadsLimit;

        MediaSettings(String serviceUrl, String mediaSetUrl, String productId, int loadTimeoutMs, int activeUploadsLimit) {
            this.serviceUrl = serviceUrl;
            this.mediaSetUrl = mediaSetUrl;
            this.productId = productId;
            this.loadTimeoutMs = loadTimeoutMs;
            this.activeUploadsLimit = activeUploadsLimit;
        }
    }

    class ConversationBuilderImpl
    implements ConversationsClient.ConversationBuilder {
        private Conversations backref;
        private String friendlyName = null;
        private String uniqueName = null;
        Attributes attributes = Attributes.DEFAULT;

        private ConversationBuilderImpl(Conversations ref) {
            this.backref = ref;
        }

        @Override
        public ConversationsClient.ConversationBuilder withFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @Override
        public ConversationsClient.ConversationBuilder withUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            return this;
        }

        @Override
        public ConversationsClient.ConversationBuilder withAttributes(@NonNull Attributes attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public void build(CallbackListener<Conversation> listener) {
            this.backref.nativeCreateConversation(this.friendlyName, this.uniqueName, this.attributes.toString(), new CallbackListenerForwarder<Conversation>(listener));
        }
    }
}

