/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.User;
import java.util.Date;

public interface Participant {
    public String getSid();

    public Long getLastReadMessageIndex();

    public String getLastReadTimestamp();

    public String getDateCreated();

    public Date getDateCreatedAsDate();

    public String getDateUpdated();

    public Date getDateUpdatedAsDate();

    public Conversation getConversation();

    public String getIdentity();

    public String getChannel();

    @NonNull
    public Attributes getAttributes();

    public void setAttributes(@NonNull Attributes var1, StatusListener var2);

    public void getAndSubscribeUser(CallbackListener<User> var1);

    public void remove(StatusListener var1);

    public static enum UpdateReason {
        LAST_READ_MESSAGE_INDEX(0),
        LAST_READ_TIMESTAMP(1),
        ATTRIBUTES(2);

        private final int value;

        private UpdateReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateReason fromInt(int value) {
            for (UpdateReason t : UpdateReason.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for UpdateReason");
        }
    }
}

